/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.tck.probe.file.FileExists;

public class FileAutoDeleteOnExceptionTestCase
extends FunctionalTestCase {
    public static final String TEST_FOLDER1 = ".mule/testData1";
    public static final String TEST_FOLDER2 = ".mule/testData2";
    private Prober prober;

    public FileAutoDeleteOnExceptionTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "file-auto-delete-on-exception-config.xml";
    }

    @Before
    public void setUp() throws IOException {
        this.prober = new PollingProber(10000L, 100L);
    }

    private File createTestFile(String folder) throws IOException {
        File testFolder = new File(folder);
        testFolder.mkdirs();
        this.prober.check((Probe)new FileExists(testFolder));
        File target = File.createTempFile("mule-file-test-", ".txt", testFolder);
        target.deleteOnExit();
        this.prober.check((Probe)new FileExists(target));
        return target;
    }

    @Test
    public void testDoesNotAutoDeleteFileOnException() throws Exception {
        File target = this.createTestFile(TEST_FOLDER1);
        muleContext.start();
        FlowConstruct fileFlow = muleContext.getRegistry().lookupFlowConstruct("fileTest");
        this.prober.check((Probe)new FlowStopped(fileFlow));
        this.prober.check((Probe)new FileExists(target));
    }

    @Test
    public void testAutoDeletesFileOnExceptionIfFileWasTransformed() throws Exception {
        File target = this.createTestFile(TEST_FOLDER2);
        muleContext.start();
        FlowConstruct fileFlow = muleContext.getRegistry().lookupFlowConstruct("fileTestWithTransformation");
        this.prober.check((Probe)new FlowStopped(fileFlow));
        Assert.assertFalse((boolean)target.exists());
    }

    private static class FlowStopped
    implements Probe {
        private final FlowConstruct fileFlow;

        public FlowStopped(FlowConstruct fileFlow) {
            this.fileFlow = fileFlow;
        }

        public boolean isSatisfied() {
            return this.fileFlow.getLifecycleState().isStopped();
        }

        public String describeFailure() {
            return "Flow was not stopped after processing the exception";
        }
    }
}

