/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.file.AbstractFileFunctionalTestCase;
import org.mule.transport.file.FileTestUtils;

public class FileEncodingFunctionalTestCase
extends AbstractFileFunctionalTestCase {
    private static final String TEST_MESSAGE_EUC_JP_ENCODED = "\u3053";
    private static final int FIVE_SECONDS_TIMEOUT = 5000;
    private static final String ENCODING = "EUC-JP";

    public FileEncodingFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "file-encoding-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "file-encoding-test-flow.xml"});
    }

    @Test
    public void testReadingFileWithEucJpEncodingGetsTheRightText() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(".mule/mule-file-test-EUC-JP");
        FileTestUtils.createDataFile(this.tmpDir, TEST_MESSAGE_EUC_JP_ENCODED, ENCODING);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.request("vm://receive", 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)ENCODING, (Object)message.getEncoding());
        Assert.assertEquals((Object)TEST_MESSAGE_EUC_JP_ENCODED, (Object)message.getPayloadAsString());
    }
}

