/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.FileUtils;
import org.mule.util.concurrent.Latch;

public class FileExceptionStrategyFunctionalTestCase
extends FunctionalTestCase {
    public static final String TEST_MESSAGE = "Test file contents";
    public static final String WORKING_DIRECTORY = ".mule/temp/work-directory/";
    private Latch latch = new Latch();
    protected File inputDir;
    private Flow flow;
    private File inputFile;
    private PollingProber pollingProber = new PollingProber(5000L, 200L);

    protected String getConfigFile() {
        return "file-exception-strategy-config.xml";
    }

    @Test
    public void testMoveFile() throws Exception {
        this.attacheLatchCountdownProcessor("moveFile");
        this.inputDir = new File(".mule/temp/input-move-file");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        this.latch.await(2000L, TimeUnit.MILLISECONDS);
        this.flow.stop();
        File outputFile = new File(".mule/temp/output-directory/" + this.inputFile.getName());
        Assert.assertThat((Object)this.inputFile.exists(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)outputFile.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMoveFileWithWorDir() throws Exception {
        this.attacheLatchCountdownProcessor("moveFileWithWorkDir");
        this.inputDir = new File(".mule/temp/input-move-file-wd");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        this.latch.await(2000L, TimeUnit.MILLISECONDS);
        this.flow.stop();
        File outputFile = new File(".mule/temp/output-directory/" + this.inputFile.getName());
        File workDirFile = new File(WORKING_DIRECTORY + this.inputFile.getName());
        Assert.assertThat((Object)this.inputFile.exists(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)outputFile.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)workDirFile.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCopyFile() throws Exception {
        this.attacheLatchCountdownProcessor("copyFile");
        this.inputDir = new File(".mule/temp/input-copy-file");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        this.latch.await(2000L, TimeUnit.MILLISECONDS);
        this.flow.stop();
        File outputFile = new File(".mule/temp/output-directory/" + this.inputFile.getName());
        Assert.assertThat((Object)this.inputFile.exists(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)outputFile.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCopyFileWithWorkDir() throws Exception {
        this.attacheLatchCountdownProcessor("copyFileWithWorkDir");
        this.inputDir = new File(".mule/temp/input-copy-file-with-work-directory");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        this.latch.await(2000L, TimeUnit.MILLISECONDS);
        this.flow.stop();
        File outputFile = new File(".mule/temp/output-directory/" + this.inputFile.getName());
        File workDirFile = new File(WORKING_DIRECTORY + this.inputFile.getName());
        Assert.assertThat((Object)this.inputFile.exists(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)outputFile.exists(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)workDirFile.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testConsumeFileWithExAndCatch() throws Exception {
        this.inputDir = new File(".mule/temp/input-streaming-catch");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        this.pollingProber.check(new Probe(){

            public boolean isSatisfied() {
                return !FileExceptionStrategyFunctionalTestCase.this.inputFile.exists();
            }

            public String describeFailure() {
                return "input file should be deleted";
            }
        });
    }

    @Test
    public void testConsumeFileWithExAndRollback() throws Exception {
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("consumeFileWithStreamingAndRollback");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                countDownLatch.countDown();
                throw new RuntimeException();
            }
        });
        this.inputDir = new File(".mule/temp/input-streaming-rollback");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        if (!countDownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"file should not be consumed");
        }
    }

    @Test
    public void testConsumeFileWithExAndRollbackWithRedelivery() throws Exception {
        final CountDownLatch countDownLatch = new CountDownLatch(3);
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("consumeFileWithStreamingAndRollbackWithRedelivery");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                countDownLatch.countDown();
                throw new RuntimeException();
            }
        });
        this.inputDir = new File(".mule/temp/input-streaming-rollback-with-redelivery");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        if (!countDownLatch.await(100000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"file should not be consumed at this point");
        }
        this.pollingProber.check(new Probe(){

            public boolean isSatisfied() {
                return !FileExceptionStrategyFunctionalTestCase.this.inputFile.exists();
            }

            public String describeFailure() {
                return "input file should be deleted";
            }
        });
    }

    @Test
    public void testConsumeFileWithAsynchronousProcessingStrategy() throws Exception {
        this.inputDir = new File(".mule/temp/input-streaming-and-async-processing-strategy");
        this.inputFile = this.createDataFile(this.inputDir, "test1.txt");
        BeforeCloseStream.releaseLatch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)this.inputFile.exists(), (Matcher)Is.is((Object)true));
        BeforeCloseStream.awaitLatch.release();
        AfterCloseStream.releaseLatch.await(5000L, TimeUnit.MILLISECONDS);
        this.pollingProber.check(new Probe(){

            public boolean isSatisfied() {
                return !FileExceptionStrategyFunctionalTestCase.this.inputFile.exists();
            }

            public String describeFailure() {
                return "input file should be deleted";
            }
        });
    }

    private void attacheLatchCountdownProcessor(String flowName) {
        this.flow = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        DefaultMessagingExceptionStrategy exceptionListener = (DefaultMessagingExceptionStrategy)this.flow.getExceptionListener();
        exceptionListener.getMessageProcessors().add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                FileExceptionStrategyFunctionalTestCase.this.latch.countDown();
                return event;
            }
        });
    }

    @Before
    public void doSetUp() {
        FileUtils.deleteTree((File)new File("./mule/temp"));
    }

    @After
    public void tearDown() {
        FileUtils.deleteTree((File)new File("./mule/temp"));
    }

    protected File createDataFile(File folder, String testMessage) throws Exception {
        return this.createDataFile(folder, testMessage, null);
    }

    protected File createDataFile(File folder, String testMessage, String encoding) throws Exception {
        File target = File.createTempFile("data", ".txt", folder);
        target.deleteOnExit();
        FileUtils.writeStringToFile((File)target, (String)testMessage, (String)encoding);
        return target;
    }

    public static class AfterCloseStream
    implements MessageProcessor {
        public static Latch releaseLatch = new Latch();
        public File file;

        public MuleEvent process(MuleEvent event) throws MuleException {
            releaseLatch.release();
            return event;
        }
    }

    public static class BeforeCloseStream
    implements MessageProcessor {
        public static Latch releaseLatch = new Latch();
        public static Latch awaitLatch = new Latch();
        public File file;

        public MuleEvent process(MuleEvent event) throws MuleException {
            releaseLatch.release();
            try {
                awaitLatch.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return event;
        }
    }
}

