/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.file.AbstractFileFunctionalTestCase;
import org.mule.transport.file.FileConnector;

public class FileFunctionalTestCase
extends AbstractFileFunctionalTestCase {
    public FileFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSend() throws Exception {
        File target = File.createTempFile("mule-file-test-", ".txt");
        target.deleteOnExit();
        FileConnector connector = (FileConnector)muleContext.getRegistry().lookupConnector("sendConnector");
        connector.setWriteToDirectory(target.getParent());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("TARGET_FILE", target.getName());
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("send", (Object)"Test file contents", props);
        this.waitForFileSystem();
        String result = new BufferedReader(new FileReader(target)).readLine();
        Assert.assertEquals((Object)"Test file contents", (Object)result);
    }

    @Test
    public void testDirectRequest() throws Exception {
        File target = this.initForRequest();
        LocalMuleClient client = muleContext.getClient();
        String url = this.fileToUrl(target) + "?connector=receiveConnector";
        this.logger.debug((Object)url);
        MuleMessage message = client.request(url, 100000L);
        this.checkReceivedMessage(message);
    }

    @Test
    public void testRecursive() throws Exception {
        File directory = new File("./.mule/in");
        File subDirectory = new File(directory.getAbsolutePath() + "/sub");
        boolean success = subDirectory.mkdir();
        Assert.assertTrue((boolean)success);
        subDirectory.deleteOnExit();
        File target = File.createTempFile("mule-file-test-", ".txt", subDirectory);
        FileWriter out = new FileWriter(target);
        out.write("Test file contents");
        ((Writer)out).close();
        target.deleteOnExit();
        LocalMuleClient client = muleContext.getClient();
        Thread.sleep(1000L);
        MuleMessage message = client.request("vm://receive?connector=vmQueue", 100000L);
        Assert.assertEquals((Object)"Test file contents", (Object)message.getPayloadAsString());
    }
}

