/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.FileUtils;

public class MoveToDirectoryPatternTestCase
extends FunctionalTestCase {
    private static final String TEST_FILENAME = "test.txt";

    protected void doTearDown() throws Exception {
        File outputDir = new File(".mule");
        Assert.assertTrue((boolean)FileUtils.deleteTree((File)outputDir));
        super.doTearDown();
    }

    @Test
    public void moveToPatternWithDirectory() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        this.writeTestMessageToInputDirectory();
        MuleMessage msg = client.request("vm://file.outbox", 3000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)"Test Message", (Object)msg.getPayload());
    }

    private void writeTestMessageToInputDirectory() throws IOException {
        File outFile = new File(".mule/files", TEST_FILENAME);
        FileOutputStream out = new FileOutputStream(outFile);
        out.write("Test Message".getBytes());
        out.close();
    }

    protected String getConfigFile() {
        return "move-to-directory-config.xml";
    }
}

