/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.FileUtils;

public class FileComparatorTestCase
extends FunctionalTestCase {
    public static final String FILE_CONNECTOR_NAME = "fileConnector";
    public static final int TIMEOUT = 50000;
    public static final String[] FILE_NAMES = new String[]{"first", "second"};
    public static final String COMPONENT_NAME = "FolderTO";
    public static final String INPUT_FOLDER = "in";

    protected String getConfigFile() {
        return "file-functional-config.xml";
    }

    @Test
    public void testComparator() throws Exception {
        final CountDownLatch countDown = new CountDownLatch(2);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                int index = (int)countDown.getCount() - 1;
                Assert.assertEquals((Object)FILE_NAMES[index], (Object)context.getMessage().getInboundProperty("originalFilename"));
                countDown.countDown();
            }
        };
        ((FunctionalTestComponent)this.getComponent(COMPONENT_NAME)).setEventCallback(callback);
        muleContext.getRegistry().lookupConnector(FILE_CONNECTOR_NAME).stop();
        File f1 = FileUtils.newFile((String)this.getFileInsideWorkingDirectory(INPUT_FOLDER + File.separator + FILE_NAMES[0]).getAbsolutePath());
        Assert.assertTrue((boolean)f1.createNewFile());
        Thread.sleep(1000L);
        File f2 = FileUtils.newFile((String)this.getFileInsideWorkingDirectory(INPUT_FOLDER + File.separator + FILE_NAMES[1]).getAbsolutePath());
        Assert.assertTrue((boolean)f2.createNewFile());
        Thread.sleep(1000L);
        muleContext.getRegistry().lookupConnector(FILE_CONNECTOR_NAME).start();
        Assert.assertTrue((boolean)countDown.await(50000L, TimeUnit.MILLISECONDS));
    }
}

