/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.file.AbstractFileMuleMessageFactoryTestCase;
import org.mule.transport.file.FileContentsMuleMessageFactory;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.util.IOUtils;

public class FileContentsMuleMessageFactoryTestCase
extends AbstractFileMuleMessageFactoryTestCase {
    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.fillTempFile();
    }

    private void fillTempFile() throws Exception {
        FileWriter writer = new FileWriter(this.tempFile);
        writer.write("Test Message");
        ((Writer)writer).close();
    }

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new FileContentsMuleMessageFactory();
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        this.assertPayload(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPayloadFromInputStream() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        ReceiverFileInputStream stream = null;
        try {
            stream = new ReceiverFileInputStream(this.tempFile, false, null);
            MuleMessage message = factory.create((Object)stream, this.encoding, muleContext);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)this.tempFile.delete());
            this.assertPayload(message);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    private void assertPayload(MuleMessage message) {
        byte[] expected = "Test Message".getBytes();
        byte[] result = (byte[])message.getPayload();
        Assert.assertTrue((boolean)Arrays.equals(expected, result));
    }
}

