/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;

public class WorkDirectoryPropertiesTestCase
extends FunctionalTestCase {
    private File dataFolder;

    public WorkDirectoryPropertiesTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "work-directory-properties-config.xml";
    }

    @Before
    public void createDataFolder() throws Exception {
        this.dataFolder = new File(muleContext.getConfiguration().getWorkingDirectory(), "data");
        if (!this.dataFolder.exists()) {
            Assert.assertTrue((String)"Unable to create test folder", (boolean)this.dataFolder.mkdirs());
        }
    }

    @Test
    public void testName() throws Exception {
        File testfile = this.createTestFile(this.dataFolder, "sample.txt");
        muleContext.start();
        MuleMessage response = muleContext.getClient().request("vm://testOut", 30000L);
        Assert.assertTrue((boolean)(response.getPayload() instanceof Map));
        Map payload = (Map)response.getPayload();
        Assert.assertEquals((Object)this.dataFolder.getCanonicalPath(), payload.get("sourceDirectory"));
        Assert.assertEquals((Object)testfile.getName(), payload.get("sourceFileName"));
    }

    private File createTestFile(File parentFolder, String fileName) throws IOException {
        File result = new File(parentFolder, fileName);
        FileOutputStream out = new FileOutputStream(result);
        out.write("Test Message".getBytes());
        out.close();
        return result;
    }
}

