/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.FileUtils;

public class WorkDirectoryTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String TEST_FILENAME = "test.txt";

    public WorkDirectoryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "work-directory-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "work-directory-config-flow.xml"});
    }

    protected void doTearDown() throws Exception {
        File outputDir = this.getWorkingDirectory();
        Assert.assertTrue((boolean)FileUtils.deleteTree((File)outputDir));
        super.doTearDown();
    }

    @Test
    public void testWorkDirectory() throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("relay");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                File workDir = WorkDirectoryTestCase.this.getFileInsideWorkingDirectory("work");
                String[] filenames = workDir.list();
                Assert.assertTrue((filenames.length > 0 ? 1 : 0) != 0);
                for (String filename : filenames) {
                    if (!filename.contains(WorkDirectoryTestCase.TEST_FILENAME)) continue;
                    return;
                }
                Assert.fail((String)"no work dir file matching filename test.txt");
            }
        });
        this.writeTestMessageToInputDirectory();
        this.checkOutputDirectory();
    }

    private void writeTestMessageToInputDirectory() throws FileNotFoundException, IOException {
        File outFile = new File(this.getFileInsideWorkingDirectory("in"), TEST_FILENAME);
        FileOutputStream out = new FileOutputStream(outFile);
        out.write("Test Message".getBytes());
        out.close();
    }

    private void checkOutputDirectory() throws Exception {
        for (int i = 0; i < 30; ++i) {
            String[] filenames;
            File outDir = this.getFileInsideWorkingDirectory("out");
            if (outDir.exists() && (filenames = outDir.list()).length > 0) {
                for (String filename : filenames) {
                    if (!filename.contains(TEST_FILENAME)) continue;
                    return;
                }
            }
            Thread.sleep(1000L);
        }
        Assert.fail((String)"no file with name test.txt in output directory");
    }
}

