/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.filters;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.FileUtils;

public class FilterOnGlobalFileEndpointTestCase
extends FunctionalTestCase {
    private static final String TEXT_FILE = "sample.txt";
    private static final String XML_FILE = "sample.xml";
    private File pollDirectory;

    protected String getConfigFile() {
        return "global-file-ep-with-filter.xml";
    }

    protected void doSetUp() throws Exception {
        this.createPollDirectoryAndInputFiles();
        super.doSetUp();
    }

    protected void doTearDown() throws Exception {
        Assert.assertTrue((boolean)FileUtils.deleteTree((File)this.pollDirectory.getParentFile()));
        super.doTearDown();
    }

    private void createPollDirectoryAndInputFiles() throws IOException {
        this.pollDirectory = this.createDirectory("target/FilterOnGlobalFileEndpointTestCase/testdir");
        this.createDirectory("target/FilterOnGlobalFileEndpointTestCase/testdir-moveto");
        this.createFileInPollDirectory(TEXT_FILE);
        this.createFileInPollDirectory(XML_FILE);
    }

    private File createDirectory(String path) {
        File directory = new File(path);
        if (!directory.exists() && !directory.mkdirs()) {
            Assert.fail((String)"could not create poll directory");
        }
        return directory;
    }

    private void createFileInPollDirectory(String filename) throws IOException {
        File file = FileUtils.newFile((File)this.pollDirectory, (String)filename);
        String path = file.getCanonicalPath();
        File newFile = FileUtils.createFile((String)path);
        newFile.deleteOnExit();
    }

    @Test
    public void testMoveFiles() throws Exception {
        File txtFile = new File(this.pollDirectory, TEXT_FILE);
        File xmlFile = new File(this.pollDirectory, XML_FILE);
        Assert.assertTrue((boolean)txtFile.exists());
        Assert.assertTrue((boolean)xmlFile.exists());
        LocalMuleClient client = muleContext.getClient();
        client.request("globalEP", 1000L);
        Assert.assertTrue((boolean)txtFile.exists());
        junit.framework.Assert.assertFalse((boolean)xmlFile.exists());
    }
}

