/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.reliability;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;
import org.mule.transport.file.FileTestUtils;

public class InboundMessageLossTestCase
extends AbstractFileMoveDeleteTestCase {
    protected Prober prober = new PollingProber(10000L, 100L);

    public InboundMessageLossTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected String getConfigFile() {
        return "reliability/inbound-message-loss.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
    }

    @Test
    public void testNoException() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("noException").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testTransformerException() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("transformerException").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }

    @Test
    public void testRouterException() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("routerException").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }

    @Test
    public void testComponentException() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("componentException").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testCatchExceptionStrategyConsumesMessage() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("exceptionHandled").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testDefaultExceptionStrategyConsumesMessage() throws Exception {
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("commitOnException").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Ignore(value="MULE-6926: Flaky Test")
    @Test
    public void testRollbackExceptionStrategyConsumesMessage() throws Exception {
        final CountDownLatch exceptionStrategyLatch = new CountDownLatch(4);
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                exceptionStrategyLatch.countDown();
            }
        });
        this.tmpDir = FileTestUtils.createFolder(this.getFileInsideWorkingDirectory("rollbackOnException").getAbsolutePath());
        final File file = FileTestUtils.createDataFile(this.tmpDir, "test1.txt");
        if (!exceptionStrategyLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should be redelivered");
        }
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }
}

