/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.io.IOUtils;
import org.mule.MuleManager;
import org.mule.providers.http.HttpRequest;
import org.mule.providers.http.HttpResponse;
import org.mule.providers.http.RequestLine;
import org.mule.providers.http.ResponseWriter;

public class HttpServerConnection {
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean keepAlive = false;
    private String encoding;

    public HttpServerConnection(Socket socket) throws IOException {
        this(socket, MuleManager.getConfiguration().getEncoding());
    }

    public HttpServerConnection(Socket socket, String encoding) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.in = socket.getInputStream();
        this.out = new DataOutputStream(socket.getOutputStream());
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket = null;
        }
    }

    public synchronized boolean isOpen() {
        return this.socket != null;
    }

    public void setKeepAlive(boolean b) {
        this.keepAlive = b;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public ResponseWriter getWriter() throws UnsupportedEncodingException {
        return new ResponseWriter(this.out);
    }

    public HttpRequest readRequest() throws IOException {
        String line = null;
        try {
            while ((line = HttpParser.readLine((InputStream)this.in, (String)this.encoding)) != null && line.length() == 0) {
            }
            if (line == null) {
                this.setKeepAlive(false);
                return null;
            }
            HttpRequest request = new HttpRequest(RequestLine.parseLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)this.encoding), this.in);
            return request;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public HttpResponse readResponse() throws IOException {
        try {
            String line = null;
            while ((line = HttpParser.readLine((InputStream)this.in, (String)this.encoding)) != null && line.length() == 0) {
            }
            if (line == null) {
                this.setKeepAlive(false);
                return null;
            }
            HttpResponse response = new HttpResponse(new StatusLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)this.encoding), this.in);
            return response;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void writeRequest(HttpRequest request) throws IOException {
        if (request == null) {
            return;
        }
        ResponseWriter writer = new ResponseWriter(this.out, this.encoding);
        writer.println(request.getRequestLine().toString());
        Iterator item = request.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        OutputStream outstream = this.out;
        InputStream content = request.getBody();
        if (content != null) {
            Header transferenc = request.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                request.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream(outstream);
                }
            }
            IOUtils.copy((InputStream)content, (OutputStream)outstream);
            if (outstream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outstream).finish();
            }
        }
        outstream.flush();
    }

    public void writeResponse(HttpResponse response) throws IOException {
        if (response == null) {
            return;
        }
        this.setKeepAlive(response.isKeepAlive());
        ResponseWriter writer = new ResponseWriter(this.out, this.encoding);
        OutputStream outstream = this.out;
        writer.println(response.getStatusLine());
        Iterator item = response.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        InputStream content = response.getBody();
        if (content != null) {
            Header transferenc = response.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                response.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream(outstream);
                }
            }
            IOUtils.copy((InputStream)content, (OutputStream)outstream);
            if (outstream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outstream).finish();
            }
        }
        outstream.flush();
    }

    public int getSocketTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void setSocketTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }
}

