/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.providers.http.HttpConstants;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOMessageReceiver;

public class HttpConnector
extends TcpConnector {
    public static final String HTTP_STATUS_PROPERTY = "http.status";
    public static final String HTTP_VERSION_PROPERTY = "http.version";
    public static final String HTTP_CUSTOM_HEADERS_MAP_PROPERTY = "http.custom.headers";
    public static final String HTTP_METHOD_PROPERTY = "http.method";
    public static final String HTTP_REQUEST_PROPERTY = "http.request";
    public static final String HTTP_PARAMS = "http.params";
    public static final String HTTP_GET_BODY_PARAM_PROPERTY = "http.get.body.param";
    public static final String DEFAULT_HTTP_GET_BODY_PARAM_PROPERTY = "body";
    public static final String HTTP_POST_BODY_PARAM_PROPERTY = "http.post.body.param";
    public static final String HTTP_COOKIE_SPEC_PROPERTY = "cookieSpec";
    public static final String HTTP_COOKIES_PROPERTY = "cookies";
    public static final String HTTP_ENABLE_COOKIES_PROPERTY = "enableCookies";
    public static final String COOKIE_SPEC_NETSCAPE = "netscape";
    public static final String COOKIE_SPEC_RFC2109 = "rcf2109";
    private String proxyHostname = null;
    private int proxyPort = 80;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String cookieSpec;
    private boolean enableCookies = false;

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        Map endpointProperties;
        if (endpoint != null && (endpointProperties = endpoint.getProperties()) != null) {
            HashMap newProperties = new HashMap(endpointProperties.size());
            Iterator entries = endpointProperties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                Object normalizedKey = HttpConstants.ALL_HEADER_NAMES.get(key);
                if (normalizedKey != null) {
                    key = normalizedKey;
                }
                newProperties.put(key, entry.getValue());
            }
            endpoint.setProperties(newProperties);
        }
        return super.registerListener(component, endpoint);
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        String key = endpoint.getEndpointURI().toString();
        int i = key.indexOf(63);
        if (i > -1) {
            key = key.substring(0, i);
        }
        return key;
    }

    public String getProtocol() {
        return "http";
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyHostname(String host) {
        this.proxyHostname = host;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public Map getReceivers() {
        return this.receivers;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public void setCookieSpec(String cookieSpec) {
        if (!cookieSpec.equalsIgnoreCase(COOKIE_SPEC_NETSCAPE) || !cookieSpec.equalsIgnoreCase(COOKIE_SPEC_RFC2109)) {
            throw new IllegalArgumentException(new Message(189, (Object)HTTP_COOKIE_SPEC_PROPERTY, (Object)cookieSpec).toString());
        }
        this.cookieSpec = cookieSpec;
    }

    public boolean isEnableCookies() {
        return this.enableCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
    }
}

