/*
 * $Id: JettyConnector.java 3798 2006-11-04 04:07:14Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.providers.http.jetty;

import org.mule.providers.http.HttpConnector;

/**
 * <code>ServletConnector</code> is a channel adapter between Mule and a servlet
 * engine.
 * 
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3798 $
 */

public class JettyConnector extends HttpConnector
{
    public JettyConnector()
    {
        super();
        registerSupportedProtocol("http");
        registerSupportedProtocol("https");
        registerSupportedProtocol("rest");
    }

    public String getProtocol()
    {
        return "jetty";
    }

}
