/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.mule.providers.AbstractConnector;
import org.mule.providers.http.HttpMessageReceiver;
import org.mule.providers.http.HttpsConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class HttpsMessageReceiver
extends HttpMessageReceiver {
    public HttpsMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super((UMOConnector)connector, component, endpoint);
    }

    protected ServerSocket createSocket(URI uri) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        HttpsConnector cnn = (HttpsConnector)this.connector;
        SSLContext sslc = SSLContext.getInstance(cnn.getSslType(), cnn.getProvider());
        sslc.init(cnn.getKeyManagerFactory().getKeyManagers(), cnn.getTrustManagerFactory().getTrustManagers(), new SecureRandom());
        SSLServerSocketFactory ssf = sslc.getServerSocketFactory();
        String host = StringUtils.defaultIfEmpty((String)uri.getHost(), (String)"localhost");
        int backlog = cnn.getBacklog();
        InetAddress inetAddress = InetAddress.getByName(host);
        SSLServerSocket serverSocket = inetAddress.equals(InetAddress.getLocalHost()) || inetAddress.isLoopbackAddress() || host.trim().equals("localhost") ? (SSLServerSocket)ssf.createServerSocket(uri.getPort(), backlog) : (SSLServerSocket)ssf.createServerSocket(uri.getPort(), backlog, inetAddress);
        serverSocket.setNeedClientAuth(cnn.isRequireClientAuthentication());
        return serverSocket;
    }
}

