/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.http.servlet.AbstractReceiverServlet;
import org.mule.providers.http.servlet.HttpRequestMessageAdapter;
import org.mule.providers.http.servlet.ServletConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.NoReceiverForEndpointException;
import org.mule.util.PropertiesUtils;

public class MuleReceiverServlet
extends AbstractReceiverServlet {
    private static final long serialVersionUID = 6631307373079767439L;
    protected ServletConnector connector = null;

    protected void doInit(ServletConfig servletConfig) throws ServletException {
        this.connector = (ServletConnector)ConnectorFactory.getConnectorByProtocol((String)"servlet");
        if (this.connector == null) {
            throw new ServletException("No servlet connector found using protocol: servlet");
        }
    }

    protected void doInit() throws ServletException {
        super.doInit();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AbstractMessageReceiver receiver = this.getReceiverForURI(request);
            UMOMessage responseMessage = null;
            MuleMessage requestMessage = new MuleMessage((Object)new HttpRequestMessageAdapter(request));
            requestMessage.setProperty("http.method", (Object)"GET");
            responseMessage = receiver.routeMessage((UMOMessage)requestMessage, true);
            this.writeResponse(response, responseMessage);
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AbstractMessageReceiver receiver = this.getReceiverForURI(request);
            UMOMessage responseMessage = null;
            MuleMessage requestMessage = new MuleMessage((Object)new HttpRequestMessageAdapter(request));
            requestMessage.setProperty("http.method", (Object)"POST");
            responseMessage = receiver.routeMessage((UMOMessage)requestMessage, receiver.getEndpoint().isSynchronous());
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected AbstractMessageReceiver getReceiverForURI(HttpServletRequest httpServletRequest) throws EndpointException {
        String uri = this.getReceiverName(httpServletRequest);
        if (uri == null) {
            throw new EndpointException(new Message("http", 4, (Object)httpServletRequest.getRequestURI()));
        }
        AbstractMessageReceiver receiver = (AbstractMessageReceiver)this.getReceivers().get(uri);
        if (receiver == null) {
            int i = uri.lastIndexOf("/");
            if (i > -1) {
                uri = uri.substring(i + 1);
                receiver = (AbstractMessageReceiver)this.getReceivers().get(uri);
            }
            if (receiver == null) {
                throw new NoReceiverForEndpointException("No receiver found for endpointUri: " + uri);
            }
        }
        receiver.getEndpoint().setEndpointURI((UMOEndpointURI)new MuleEndpointURI(this.getRequestUrl(httpServletRequest)));
        return receiver;
    }

    protected String getRequestUrl(HttpServletRequest httpServletRequest) {
        StringBuffer url = new StringBuffer();
        url.append(this.connector.getProtocol().toLowerCase());
        url.append(":");
        url.append(httpServletRequest.getScheme());
        url.append("://");
        url.append(httpServletRequest.getServerName());
        url.append(":");
        url.append(httpServletRequest.getServerPort());
        url.append("/");
        url.append(this.getReceiverName(httpServletRequest));
        if (httpServletRequest.getQueryString() != null) {
            url.append("?");
            url.append(httpServletRequest.getQueryString());
        }
        return url.toString();
    }

    protected String getReceiverName(HttpServletRequest httpServletRequest) {
        Properties params;
        String name = httpServletRequest.getPathInfo();
        if (name == null && (name = httpServletRequest.getParameter("endpoint")) == null && (name = (params = PropertiesUtils.getPropertiesFromQueryString((String)httpServletRequest.getQueryString())).getProperty("endpoint")) == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    protected Map getReceivers() {
        return this.connector.getReceivers();
    }
}

