/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.mule.MuleManager;
import org.mule.providers.NullPayload;
import org.mule.providers.http.HttpConstants;
import org.mule.providers.http.HttpResponse;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class UMOMessageToHttpResponse
extends AbstractEventAwareTransformer {
    private static final long serialVersionUID = 9137870668198309755L;
    public static final String CUSTOM_HEADER_PREFIX = "";
    private SimpleDateFormat format = null;
    private String server = null;
    private SerializableToByteArray serializableToByteArray;

    public UMOMessageToHttpResponse() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
        this.format = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        this.server = MuleManager.getConfiguration().getProductName() == null ? "Mule/SNAPSHOT" : MuleManager.getConfiguration().getProductName() + "/" + MuleManager.getConfiguration().getProductVersion();
        this.serializableToByteArray = new SerializableToByteArray();
    }

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        if (context.getMessage().getExceptionPayload() != null) {
            // empty if block
        }
        if (src instanceof NullPayload) {
            src = CUSTOM_HEADER_PREFIX;
        }
        try {
            HttpResponse response = null;
            response = src instanceof HttpResponse ? (HttpResponse)src : this.createResponse(src, encoding, context);
            if (!response.containsHeader("Content-Type")) {
                response.addHeader(new Header("Content-Type", "text/plain"));
            }
            if (!response.containsHeader("Content-Length") && !response.containsHeader("Transfer-Encoding")) {
                InputStream content = response.getBody();
                if (content != null) {
                    long len = response.getContentLength();
                    if (len < 0L) {
                        if (response.getHttpVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                            throw new IOException("Chunked encoding not supported for HTTP version " + response.getHttpVersion());
                        }
                        Header header = new Header("Transfer-Encoding", "chunked");
                        response.addHeader(header);
                    } else {
                        Header header = new Header("Content-Length", Long.toString(len));
                        response.setHeader(header);
                    }
                } else {
                    Header header = new Header("Content-Length", "0");
                    response.addHeader(header);
                }
            }
            UMOMessage msg = context.getMessage();
            if (!response.containsHeader("Connection")) {
                String connHeader = msg.getStringProperty("Connection", null);
                if (connHeader != null) {
                    Header header;
                    if (connHeader.equalsIgnoreCase("keep-alive")) {
                        header = new Header("Connection", "keep-alive");
                        response.addHeader(header);
                        response.setKeepAlive(true);
                    }
                    if (connHeader.equalsIgnoreCase("close")) {
                        header = new Header("Connection", "close");
                        response.addHeader(header);
                        response.setKeepAlive(false);
                    }
                } else if (response.getHttpVersion().greaterEquals(HttpVersion.HTTP_1_1)) {
                    response.setKeepAlive(true);
                } else {
                    response.setKeepAlive(false);
                }
            }
            if ("HEAD".equalsIgnoreCase(msg.getStringProperty("http.method", null))) {
                response.setBody(null);
            }
            return response;
        }
        catch (IOException e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected HttpResponse createResponse(Object src, String encoding, UMOEventContext context) throws IOException, TransformerException {
        String user;
        HttpResponse response = new HttpResponse();
        UMOMessage msg = context.getMessage();
        int status = msg.getIntProperty("http.status", 200);
        String version = msg.getStringProperty("http.version", "HTTP/1.1");
        String date = this.format.format(new Date());
        String contentType = msg.getStringProperty("Content-Type", "text/plain");
        response.setStatusLine(HttpVersion.parse((String)version), status);
        response.setHeader(new Header("Content-Type", contentType));
        response.setHeader(new Header("Date", date));
        response.setHeader(new Header("Server", this.server));
        if (msg.getProperty("Expires") == null) {
            response.setHeader(new Header("Expires", date));
        }
        response.setFallbackCharset(encoding);
        Collection headerNames = HttpConstants.RESPONSE_HEADER_NAMES.values();
        Iterator iterator = headerNames.iterator();
        while (iterator.hasNext()) {
            String headerName = (String)iterator.next();
            String value = msg.getStringProperty(headerName, null);
            if (value == null) continue;
            response.setHeader(new Header(headerName, value));
        }
        Map customHeaders = (Map)msg.getProperty("http.custom.headers");
        if (customHeaders != null) {
            Iterator iterator2 = customHeaders.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                if (entry.getValue() == null) continue;
                response.setHeader(new Header(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
        if ((user = msg.getStringProperty("MULE_USER", null)) != null) {
            response.setHeader(new Header("MULE_USER", user));
        }
        if (msg.getCorrelationId() != null) {
            response.setHeader(new Header("MULE_CORRELATION_ID", msg.getCorrelationId()));
            response.setHeader(new Header("MULE_CORRELATION_GROUP_SIZE", String.valueOf(msg.getCorrelationGroupSize())));
            response.setHeader(new Header("MULE_CORRELATION_SEQUENCE", String.valueOf(msg.getCorrelationSequence())));
        }
        if (msg.getReplyTo() != null) {
            response.setHeader(new Header("MULE_REPLYTO", msg.getReplyTo().toString()));
        }
        if (src instanceof InputStream) {
            response.setBody((InputStream)src);
        } else if (src instanceof String) {
            response.setBodyString(src.toString());
        } else {
            response.setBody(new ByteArrayInputStream((byte[])this.serializableToByteArray.doTransform(src, encoding)));
        }
        return response;
    }

    public boolean isAcceptNull() {
        return true;
    }
}

