/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.SystemUtils;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.http.i18n.ServletMessages;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UniqueIdNotSupportedException;

public class HttpRequestMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -4238448252206941125L;
    private Object message = null;
    private HttpServletRequest request;

    public HttpRequestMessageAdapter(Object message) throws MessagingException {
        if (message instanceof HttpServletRequest) {
            String key;
            this.setPayload((HttpServletRequest)message);
            Map parameterMap = this.request.getParameterMap();
            if (parameterMap != null && parameterMap.size() > 0) {
                Iterator iterator = parameterMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String key2 = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    if (value.getClass().isArray() && ((Object[])value).length == 1) {
                        this.setProperty(key2, ((Object[])value)[0]);
                        continue;
                    }
                    this.setProperty(key2, value);
                }
            }
            Enumeration e = this.request.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                this.properties.put((Object)key, this.request.getAttribute(key));
            }
            Enumeration e2 = this.request.getHeaderNames();
            while (e2.hasMoreElements()) {
                String realKey = key = (String)e2.nextElement();
                if (key.startsWith("X-MULE_")) {
                    realKey = key.substring(2);
                }
                this.setProperty(realKey, this.request.getHeader(key));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    public Object getPayload() {
        return this.message;
    }

    public boolean isBinary() {
        return this.message instanceof byte[];
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.isBinary()) {
            return (byte[])this.message;
        }
        return ((String)this.message).getBytes();
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.isBinary()) {
            return new String((byte[])this.message, encoding);
        }
        return (String)this.message;
    }

    private void setPayload(HttpServletRequest message) throws MessagingException {
        try {
            String payload;
            this.request = message;
            String payloadParam = (String)this.request.getAttribute("org.mule.servlet.payload.param");
            if (payloadParam == null) {
                payloadParam = "payload";
            }
            if ((payload = this.request.getParameter(payloadParam)) == null) {
                if (this.isText(this.request.getContentType())) {
                    BufferedReader reader = this.request.getReader();
                    StringBuffer buffer = new StringBuffer(8192);
                    String line = reader.readLine();
                    while (line != null) {
                        buffer.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        buffer.append(SystemUtils.LINE_SEPARATOR);
                    }
                    this.message = buffer.toString();
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                    IOUtils.copy((InputStream)this.request.getInputStream(), (OutputStream)baos);
                    this.message = baos.toByteArray();
                }
            } else {
                this.message = payload;
            }
        }
        catch (IOException e) {
            throw new MessagingException(ServletMessages.failedToReadPayload(this.request.getRequestURL().toString()), (Object)e);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getUniqueId() {
        HttpSession session = null;
        try {
            session = this.getRequest().getSession();
        }
        catch (Exception e) {
            throw new UniqueIdNotSupportedException((UMOMessageAdapter)this, CoreMessages.objectIsNull((String)"Http session"));
        }
        if (session == null) {
            throw new UniqueIdNotSupportedException((UMOMessageAdapter)this, CoreMessages.objectIsNull((String)"Http session"));
        }
        return session.getId();
    }

    protected boolean isText(String contentType) {
        if (contentType == null) {
            return true;
        }
        return contentType.startsWith("text/");
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo.toString().startsWith("http")) {
            this.setProperty("Location", replyTo);
        }
        this.setProperty("MULE_CORRELATION_ID", replyTo);
    }

    public Object getReplyTo() {
        String replyto = (String)this.getProperty("MULE_REPLYTO");
        if (replyto == null) {
            replyto = (String)this.getProperty("Location");
        }
        return replyto;
    }
}

