/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractPollingMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.Base64;
import org.mule.util.MapUtils;

public class PollingHttpMessageReceiver
extends AbstractPollingMessageReceiver {
    private URL pollUrl;
    private static final int DEFAULT_BUFFER_SIZE = 32768;

    public PollingHttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        long pollingFrequency = MapUtils.getLongValue((Map)endpoint.getProperties(), (Object)"pollingFrequency", (long)-1L);
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
        try {
            this.pollUrl = new URL(endpoint.getEndpointURI().getAddress());
        }
        catch (MalformedURLException e) {
            throw new InitialisationException(CoreMessages.valueIsInvalidFor((String)endpoint.getEndpointURI().getAddress(), (String)"uri"), (Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        String connectUrl = (String)this.endpoint.getProperties().get("connectUrl");
        URL url = connectUrl == null ? this.pollUrl : new URL(connectUrl);
        this.logger.debug((Object)("Using url to connect: " + this.pollUrl.toString()));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.disconnect();
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)this.pollUrl.openConnection();
        String authentication = this.endpoint.getEndpointURI().getUserInfo();
        if (authentication != null) {
            connection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])authentication.getBytes()));
        }
        int bytesWritten = 0;
        int contentLength = connection.getContentLength();
        boolean contentLengthNotSet = false;
        if (contentLength < 0) {
            contentLength = 32768;
            contentLengthNotSet = true;
        }
        byte[] buffer = new byte[32768];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(contentLength);
        InputStream is = connection.getInputStream();
        while (bytesWritten != contentLength) {
            int len = is.read(buffer);
            if (len != -1) {
                baos.write(buffer, 0, len);
                bytesWritten += len;
                continue;
            }
            if (!contentLengthNotSet) continue;
            contentLength = bytesWritten;
        }
        buffer = baos.toByteArray();
        baos.close();
        HashMap<String, String> respHeaders = new HashMap<String, String>();
        Iterator<Map.Entry<String, List<String>>> it = connection.getHeaderFields().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> msgHeader = it.next();
            String key = msgHeader.getKey();
            List<String> value = msgHeader.getValue();
            if (key == null || value == null) continue;
            respHeaders.put(key, value.get(0));
        }
        UMOMessageAdapter adapter = this.connector.getMessageAdapter((Object)new Object[]{buffer, respHeaders});
        connection.disconnect();
        MuleMessage message = new MuleMessage((Object)adapter);
        this.routeMessage((UMOMessage)message, this.endpoint.isSynchronous());
    }
}

