/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.jetty;

import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;
import org.mule.MuleManager;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.http.i18n.HttpMessages;
import org.mule.providers.http.jetty.JettyReceiverServlet;
import org.mule.providers.http.servlet.MuleRESTReceiverServlet;
import org.mule.providers.http.servlet.ServletConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.StringUtils;

public class JettyHttpMessageReceiver
extends AbstractMessageReceiver {
    public static final String JETTY_SERVLET_CONNECTOR_NAME = "_jettyConnector";
    private Server httpServer;

    public JettyHttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        if ("rest".equals(endpoint.getEndpointURI().getScheme())) {
            ServletConnector scon = (ServletConnector)MuleManager.getInstance().lookupConnector(JETTY_SERVLET_CONNECTOR_NAME);
            if (scon != null) {
                throw new InitialisationException(HttpMessages.noServletConnectorFound(JETTY_SERVLET_CONNECTOR_NAME), (Object)this);
            }
            scon = new ServletConnector();
            scon.setName(JETTY_SERVLET_CONNECTOR_NAME);
            scon.setServletUrl(endpoint.getEndpointURI().getAddress());
            try {
                MuleManager.getInstance().registerConnector((UMOConnector)scon);
                String path = endpoint.getEndpointURI().getPath();
                if (StringUtils.isEmpty((String)path)) {
                    path = "/";
                }
                MuleEndpoint ep = new MuleEndpoint("servlet://" + path.substring(1), true);
                ep.setTransformer(endpoint.getTransformer());
                scon.registerListener(component, (UMOEndpoint)ep);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Object)this);
            }
        }
    }

    protected void doConnect() throws Exception {
        this.httpServer = new Server();
        SocketListener socketListener = new SocketListener(new InetAddrPort(this.endpoint.getEndpointURI().getPort()));
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        socketListener.setMaxIdleTimeMs((int)tp.getThreadTTL());
        int threadsActive = tp.getMaxThreadsActive();
        int threadsMin = socketListener.getMinThreads();
        if (threadsMin >= threadsActive) {
            socketListener.setMinThreads(threadsActive - 1);
        }
        socketListener.setMaxThreads(threadsActive);
        this.httpServer.addListener((HttpListener)socketListener);
        String path = this.endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)path)) {
            path = "/";
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        HttpContext context = this.httpServer.getContext("/");
        context.setRequestLog(null);
        ServletHandler handler = new ServletHandler();
        if ("rest".equals(this.endpoint.getEndpointURI().getScheme())) {
            handler.addServlet("MuleRESTReceiverServlet", path + "*", MuleRESTReceiverServlet.class.getName());
        } else {
            handler.addServlet("JettyReceiverServlet", path + "*", JettyReceiverServlet.class.getName());
        }
        context.addHandler((HttpHandler)handler);
        context.setAttribute("messageReceiver", (Object)this);
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
        try {
            this.httpServer.stop(false);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Error disposing Jetty recevier on: " + this.endpoint.getEndpointURI().toString()), (Throwable)e);
        }
    }

    protected void doStart() throws UMOException {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws UMOException {
        try {
            this.httpServer.stop(true);
        }
        catch (InterruptedException e) {
            throw new LifecycleException(CoreMessages.failedToStop((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }
}

