/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;
import org.mule.impl.MuleMessage;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class HttpClientMethodResponseToObject
extends AbstractTransformer {
    public HttpClientMethodResponseToObject() {
        this.registerSourceType(HttpMethod.class);
        this.setReturnClass(UMOMessage.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        Object msg;
        HttpMethod httpMethod = (HttpMethod)src;
        Header contentType = httpMethod.getResponseHeader("Content-Type");
        try {
            msg = contentType != null && !contentType.getValue().startsWith("text/") ? (Object)IOUtils.toByteArray((InputStream)httpMethod.getResponseBodyAsStream()) : httpMethod.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
        HashMap<String, String> headerProps = new HashMap<String, String>();
        Header[] headers = httpMethod.getRequestHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String name = headers[i].getName();
            if (name.startsWith("X-MULE_")) {
                name = name.substring(2);
            }
            headerProps.put(name, headers[i].getValue());
        }
        return new MuleMessage(msg, headerProps);
    }
}

