/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.http.HttpResponse;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.transformer.UMOTransformer;

public class HttpMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -1544495479333000422L;
    private static final UMOTransformer transformer = new SerializableToByteArray();
    private final Object message;
    private boolean http11 = true;

    public HttpMessageAdapter(Object message) throws MessagingException {
        NameValuePair param;
        HeaderElement[] values;
        String temp;
        if (message instanceof Object[]) {
            this.message = ((Object[])message)[0];
            if (((Object[])message).length > 1) {
                Map props = (Map)((Object[])message)[1];
                Iterator iterator = props.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e = iterator.next();
                    String key = (String)e.getKey();
                    Object value = e.getValue();
                    if (value == null) continue;
                    this.setProperty(key, value);
                }
            }
        } else if (message instanceof byte[]) {
            this.message = message;
        } else {
            if (message instanceof HttpResponse) {
                this.message = message;
                return;
            }
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        if ("HTTP/1.0".equalsIgnoreCase(temp = this.getStringProperty("http.version", null))) {
            this.http11 = false;
        }
        String charset = null;
        Header contenttype = this.getHeader("Content-Type");
        if (contenttype != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        if (charset != null) {
            this.encoding = charset;
        }
    }

    public Object getPayload() {
        return this.message;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.message instanceof byte[]) {
            return (byte[])this.message;
        }
        if (this.message instanceof String) {
            return this.message.toString().getBytes();
        }
        return (byte[])transformer.transform(this.message);
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.message instanceof byte[]) {
            if (encoding != null) {
                return new String((byte[])this.message, encoding);
            }
            return new String((byte[])this.message);
        }
        return this.message.toString();
    }

    public Object getProperty(String key) {
        if ("Keep-Alive".equals(key) || "Connection".equals(key)) {
            if (!this.http11) {
                String connection = super.getStringProperty("Connection", null);
                if (connection != null && connection.equalsIgnoreCase("close")) {
                    return "false";
                }
                return "true";
            }
            return super.getProperty("Connection") != null ? "true" : "false";
        }
        return super.getProperty(key);
    }

    public Header getHeader(String name) {
        String value = this.getStringProperty(name, null);
        if (value == null) {
            return null;
        }
        return new Header(name, value);
    }
}

