/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.mule.RegistryContext;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.NullSessionHandler;
import org.mule.impl.RequestContext;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.NullPayload;
import org.mule.providers.http.CookieHelper;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.HttpRequest;
import org.mule.providers.http.HttpResponse;
import org.mule.providers.http.HttpServerConnection;
import org.mule.providers.http.RequestLine;
import org.mule.providers.http.i18n.HttpMessages;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    public HttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws CreateException {
        super(connector, component, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpWorker(socket);
    }

    protected void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        StringBuffer requestUri = new StringBuffer(80);
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(':').append(this.endpoint.getEndpointURI().getPort());
        requestUri.append('*');
        UMOMessageReceiver[] receivers = this.connector.getReceivers(requestUri.toString());
        for (int i = 0; i < receivers.length; ++i) {
            if (!receivers[i].isConnected()) continue;
            return false;
        }
        return true;
    }

    protected UMOMessage handleUnacceptedFilter(UMOMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message request '" + message.getProperty("http.request") + "' is being rejected since it does not match the filter on this endpoint: " + this.endpoint));
        }
        message.setProperty("http.status", (Object)String.valueOf(406));
        return message;
    }

    protected String getRequestPath(UMOMessage message) {
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    protected UMOMessageReceiver getTargetReceiver(UMOMessage message, UMOEndpoint endpoint) throws ConnectException {
        UMOMessageReceiver receiver;
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer(80);
        requestUri.append(endpoint.getProtocol()).append("://");
        requestUri.append(endpoint.getEndpointURI().getHost());
        requestUri.append(':').append(endpoint.getEndpointURI().getPort());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = this.connector.lookupReceiver(requestUri.toString())) == null && !"/".equals(path)) {
            int x = path.lastIndexOf(47);
            if (x > 1 && path.indexOf(46) > x) {
                requestUri.append(path.substring(0, x));
            } else {
                requestUri.append(path);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Secondary lookup of receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
            }
            if ((receiver = this.connector.lookupReceiver(requestUri.toString())) == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + MapUtils.toString((Map)this.connector.getReceivers(), (boolean)true)));
            }
        }
        return receiver;
    }

    private class HttpWorker
    implements Work {
        private HttpServerConnection conn = null;
        private String cookieSpec;
        private boolean enableCookies = false;

        public HttpWorker(Socket socket) throws IOException {
            String encoding = HttpMessageReceiver.this.endpoint.getEncoding();
            if (encoding == null) {
                encoding = RegistryContext.getConfiguration().getDefaultEncoding();
            }
            this.conn = new HttpServerConnection(socket, encoding);
            this.cookieSpec = MapUtils.getString((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)HttpMessageReceiver.this.connector).getCookieSpec());
            this.enableCookies = MapUtils.getBooleanValue((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)HttpMessageReceiver.this.connector).isEnableCookies());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    HttpResponse response;
                    MuleEvent event;
                    MuleMessage message;
                    this.conn.setKeepAlive(false);
                    HttpRequest request = this.conn.readRequest();
                    if (request == null) {
                        break;
                    }
                    RequestLine requestLine = request.getRequestLine();
                    String method = requestLine.getMethod();
                    if (method.equals("HEAD")) {
                        message = new MuleMessage((Object)NullPayload.getInstance());
                        event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession((UMOMessage)message, (UMOSessionHandler)new NullSessionHandler()), true);
                        RequestContext.setEvent((UMOEvent)event);
                        response = new HttpResponse();
                        response.setStatusLine(requestLine.getHttpVersion(), 200);
                        response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform((Object)response);
                    } else if (method.equals("GET") || method.equals("POST")) {
                        AbstractMessageReceiver receiver;
                        UMOStreamMessageAdapter adapter;
                        HashMap<String, Object> headers = new HashMap<String, Object>();
                        Iterator rhi = request.getHeaderIterator();
                        while (rhi.hasNext()) {
                            Header header = (Header)rhi.next();
                            String headerName = header.getName();
                            Cookie[] headerValue = header.getValue();
                            if (headerName.startsWith("X-MULE")) {
                                headerName = headerName.substring(2);
                            } else if (headerName.equals("cookies")) {
                                Cookie[] cookies;
                                if (!this.enableCookies || (cookies = CookieHelper.parseCookies(header, this.cookieSpec)).length <= 0) continue;
                                headerValue = cookies;
                            }
                            headers.put(headerName, headerValue);
                        }
                        headers.put("http.method", requestLine.getMethod());
                        headers.put("http.request", requestLine.getUri());
                        headers.put("http.version", requestLine.getHttpVersion().toString());
                        headers.put("cookieSpec", this.cookieSpec);
                        if (HttpMessageReceiver.this.endpoint.isStreaming() && request.getBody() != null) {
                            adapter = HttpMessageReceiver.this.connector.getStreamMessageAdapter(request.getBody(), this.conn.getOutputStream());
                            Iterator iterator = headers.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                adapter.setProperty((String)entry.getKey(), entry.getValue());
                            }
                        } else {
                            Object body;
                            String expectHeaderValue;
                            if (headers.get("http.version").equals("HTTP/1.1") && "100-continue".equals(expectHeaderValue = ObjectUtils.toString(headers.get("Expect")).toLowerCase())) {
                                HttpResponse expected = new HttpResponse();
                                expected.setStatusLine(requestLine.getHttpVersion(), 100);
                                MuleEvent event2 = new MuleEvent((UMOMessage)new MuleMessage((Object)expected), (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession(HttpMessageReceiver.this.component), true);
                                RequestContext.setEvent((UMOEvent)event2);
                                expected = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform((Object)expected);
                                this.conn.writeResponse(expected);
                            }
                            if ((body = request.getBodyBytes()) == null) {
                                body = requestLine.getUri();
                            }
                            adapter = HttpMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{body, headers});
                        }
                        MuleMessage message2 = new MuleMessage((Object)adapter);
                        if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                            HttpMessageReceiver.this.logger.debug(message2.getProperty("http.request"));
                        }
                        if ((receiver = (AbstractMessageReceiver)HttpMessageReceiver.this.getTargetReceiver((UMOMessage)message2, HttpMessageReceiver.this.endpoint)) != null) {
                            UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message2, HttpMessageReceiver.this.endpoint.isSynchronous(), null);
                            Object tempResponse = returnMessage != null ? returnMessage.getPayload() : NullPayload.getInstance();
                            response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(tempResponse);
                            response.disableKeepAlive(!((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive());
                        } else {
                            UMOEndpointURI uri = HttpMessageReceiver.this.endpoint.getEndpointURI();
                            String failedPath = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + HttpMessageReceiver.this.getRequestPath((UMOMessage)message2);
                            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                                HttpMessageReceiver.this.logger.debug((Object)("Failed to bind to " + failedPath));
                            }
                            response = new HttpResponse();
                            response.setStatusLine(requestLine.getHttpVersion(), 404);
                            response.setBodyString(HttpMessages.cannotBindToAddress(failedPath).toString());
                            RequestContext.setEvent((UMOEvent)new MuleEvent((UMOMessage)new MuleMessage((Object)response), (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession(HttpMessageReceiver.this.component), true));
                            response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform((Object)response);
                        }
                    } else if (method.equals("OPTIONS") || method.equals("PUT") || method.equals("DELETE") || method.equals("TRACE") || method.equals("CONNECT")) {
                        message = new MuleMessage((Object)NullPayload.getInstance());
                        event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession((UMOMessage)message, (UMOSessionHandler)new NullSessionHandler()), true);
                        RequestContext.setEvent((UMOEvent)event);
                        response = new HttpResponse();
                        response.setStatusLine(requestLine.getHttpVersion(), 405);
                        response.setBodyString(HttpMessages.methodNotAllowed(method).toString() + "\r\n");
                        response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform((Object)response);
                    } else {
                        message = new MuleMessage((Object)NullPayload.getInstance());
                        event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession((UMOMessage)message, (UMOSessionHandler)new NullSessionHandler()), true);
                        RequestContext.setEvent((UMOEvent)event);
                        response = new HttpResponse();
                        response.setStatusLine(requestLine.getHttpVersion(), 400);
                        response.setBodyString(HttpMessages.malformedSyntax().toString() + "\r\n");
                        response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform((Object)response);
                    }
                    this.conn.writeResponse(response);
                } while (this.conn.isKeepAlive());
            }
            catch (Exception e) {
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                this.conn.close();
                this.conn = null;
            }
        }

        public void release() {
            this.conn.close();
            this.conn = null;
        }
    }
}

