/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.mule.providers.NullPayload;
import org.mule.providers.http.HttpConstants;
import org.mule.providers.http.i18n.HttpMessages;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.StringUtils;

public class ObjectToHttpClientMethodRequest
extends AbstractEventAwareTransformer {
    private final SerializableToByteArray serializableToByteArray;

    public ObjectToHttpClientMethodRequest() {
        this.setReturnClass(HttpMethod.class);
        this.serializableToByteArray = new SerializableToByteArray();
    }

    private int addParameters(String queryString, PostMethod postMethod) {
        String currentParam;
        if (StringUtils.isEmpty((String)queryString)) {
            return 0;
        }
        int equals = queryString.indexOf("&");
        if (equals > -1) {
            currentParam = queryString.substring(0, equals);
            queryString = queryString.substring(equals + 1);
        } else {
            currentParam = queryString;
            queryString = "";
        }
        int parameterIndex = -1;
        while (StringUtils.isNotBlank((String)currentParam)) {
            equals = currentParam.indexOf("=");
            if (equals > -1) {
                String paramName = currentParam.substring(0, equals);
                String paramValue = currentParam.substring(equals + 1);
                ++parameterIndex;
                postMethod.addParameter(paramName, paramValue);
            }
            if ((equals = queryString.indexOf("&")) > -1) {
                currentParam = queryString.substring(0, equals);
                queryString = queryString.substring(equals + 1);
                continue;
            }
            currentParam = queryString;
            queryString = "";
        }
        return parameterIndex + 1;
    }

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        UMOMessage msg = context.getMessage();
        String endpoint = msg.getStringProperty("MULE_ENDPOINT", null);
        if (endpoint == null) {
            throw new TransformerException(HttpMessages.eventPropertyNotSetCannotProcessRequest("MULE_ENDPOINT"), (UMOTransformer)this);
        }
        String method = msg.getStringProperty("http.method", "POST");
        try {
            URI uri = new URI(endpoint);
            GetMethod httpMethod = null;
            if ("GET".equals(method)) {
                httpMethod = new GetMethod(uri.toString());
                this.setHeaders((HttpMethod)httpMethod, context);
                String paramName = msg.getStringProperty("http.get.body.param", "body");
                String query = uri.getQuery();
                if (!(src instanceof NullPayload) && !"".equals(src)) {
                    query = query == null ? paramName + "=" + src.toString() : query + "&" + paramName + "=" + src.toString();
                }
                httpMethod.setQueryString(query);
            } else {
                PostMethod postMethod = new PostMethod(uri.toString());
                this.setHeaders((HttpMethod)postMethod, context);
                String paramName = msg.getStringProperty("http.post.body.param", null);
                if (paramName == null) {
                    this.addParameters(uri.getQuery(), postMethod);
                    if (!(context.getMessage().getPayload() instanceof NullPayload)) {
                        String mimeType = msg.getStringProperty("Content-Type", null);
                        if (src instanceof String) {
                            int parameterIndex;
                            if (mimeType != null && (parameterIndex = mimeType.indexOf(";")) > 0) {
                                mimeType = mimeType.substring(0, parameterIndex);
                            }
                            if (mimeType == null) {
                                mimeType = "text/plain";
                            }
                            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(src.toString(), mimeType, encoding));
                        } else if (src instanceof InputStream) {
                            if (mimeType == null) {
                                mimeType = "text/plain";
                            }
                            postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)src, mimeType));
                        } else {
                            if (mimeType == null) {
                                mimeType = "text/plain";
                            }
                            byte[] buffer = (byte[])this.serializableToByteArray.doTransform(src, encoding);
                            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, mimeType));
                        }
                    }
                } else {
                    postMethod.addParameter(paramName, src.toString());
                }
                httpMethod = postMethod;
            }
            HttpMethodParams params = (HttpMethodParams)msg.removeProperty("http.params");
            if (params != null) {
                httpMethod.setParams(params);
            } else {
                String httpVersion = msg.getStringProperty("http.version", "HTTP/1.1");
                if ("HTTP/1.0".equals(httpVersion)) {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_0);
                } else {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_1);
                }
            }
            return httpMethod;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected void setHeaders(HttpMethod httpMethod, UMOEventContext context) {
        UMOMessage msg = context.getMessage();
        Iterator iterator = msg.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String headerName = (String)iterator.next();
            String headerValue = msg.getStringProperty(headerName, null);
            if (HttpConstants.REQUEST_HEADER_NAMES.get(headerName) != null) continue;
            if (headerName.startsWith("MULE_")) {
                headerName = new StringBuffer(30).append("X-").append(headerName).toString();
            }
            if (headerName.startsWith("Content-Length")) {
                if (httpMethod.getResponseHeader("Content-Length") != null) continue;
                httpMethod.addRequestHeader(headerName, headerValue);
                continue;
            }
            httpMethod.addRequestHeader(headerName, headerValue);
        }
        if (context.getMessage().getPayload() instanceof InputStream) {
            httpMethod.addRequestHeader("Content-Type", "multipart/related");
        }
    }
}

