/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.io.IOUtils;
import org.mule.impl.MuleMessage;
import org.mule.impl.message.ExceptionPayload;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.http.CookieHelper;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.HttpStreamMessageAdapter;
import org.mule.providers.http.MuleHttpMethodRetryHandler;
import org.mule.providers.http.i18n.HttpMessages;
import org.mule.providers.http.transformers.HttpClientMethodResponseToObject;
import org.mule.providers.http.transformers.ObjectToHttpClientMethodRequest;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.StringUtils;

public class HttpClientMessageDispatcher
extends AbstractMessageDispatcher {
    public static final int ERROR_STATUS_CODE_RANGE_START = 400;
    private final HttpConnector connector;
    private volatile HttpClient client = null;
    private final UMOTransformer receiveTransformer;

    public HttpClientMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (HttpConnector)endpoint.getConnector();
        this.receiveTransformer = new HttpClientMethodResponseToObject();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            HttpState state = new HttpState();
            if (this.connector.getProxyUsername() != null) {
                state.setProxyCredentials(new AuthScope(null, -1, null, null), (Credentials)new UsernamePasswordCredentials(this.connector.getProxyUsername(), this.connector.getProxyPassword()));
            }
            this.client = new HttpClient();
            this.client.setState(state);
            this.client.setHttpConnectionManager(this.connector.getClientConnectionManager());
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        this.execute(event, httpMethod, true);
        if (httpMethod.getStatusCode() >= 400) {
            this.logger.error((Object)httpMethod.getResponseBodyAsString());
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new Exception("Http call returned a status of: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText()));
        }
    }

    protected UMOMessage doReceive(long timeout) throws Exception {
        GetMethod httpMethod = new GetMethod(this.endpoint.getEndpointURI().getAddress());
        httpMethod.setDoAuthentication(true);
        if (this.endpoint.getEndpointURI().getUserInfo() != null && this.endpoint.getProperty((Object)"Authorization") == null) {
            StringBuffer header = new StringBuffer(128);
            header.append("Basic ");
            header.append(new String(Base64.encodeBase64((byte[])this.endpoint.getEndpointURI().getUserInfo().getBytes(this.endpoint.getEncoding()))));
            httpMethod.addRequestHeader("Authorization", header.toString());
        }
        try {
            HttpClient client = new HttpClient();
            client.executeMethod((HttpMethod)httpMethod);
            if (httpMethod.getStatusCode() == 200) {
                UMOMessage uMOMessage = (UMOMessage)this.receiveTransformer.transform((Object)httpMethod);
                return uMOMessage;
            }
            try {
                throw new ReceiveException(HttpMessages.requestFailedWithStatus(httpMethod.getStatusLine().toString()), this.endpoint, timeout);
            }
            catch (ReceiveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ReceiveException(this.endpoint, timeout, (Throwable)e);
            }
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpMethod execute(UMOEvent event, HttpMethod httpMethod, boolean closeConnection) throws Exception {
        HttpMethod httpMethod2;
        try {
            try {
                URI uri = event.getEndpoint().getEndpointURI().getUri();
                this.processCookies(event);
                this.client.executeMethod(this.getHostConfig(uri), httpMethod);
                httpMethod2 = httpMethod;
                Object var7_8 = null;
                if (httpMethod == null) return httpMethod2;
                if (!closeConnection) return httpMethod2;
            }
            catch (IOException e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (httpMethod == null) throw throwable;
            if (!closeConnection) throw throwable;
            httpMethod.releaseConnection();
            throw throwable;
        }
        httpMethod.releaseConnection();
        return httpMethod2;
    }

    protected void processCookies(UMOEvent event) {
        UMOMessage msg = event.getMessage();
        Cookie[] cookies = (Cookie[])msg.removeProperty("cookies");
        if (cookies != null && cookies.length > 0) {
            String policy = (String)msg.removeProperty("cookieSpec");
            this.client.getParams().setCookiePolicy(CookieHelper.getCookiePolicy(policy));
            this.client.getState().addCookies(cookies);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected HttpMethod getMethod(UMOEvent event) throws TransformerException {
        void var5_6;
        PutMethod postMethod;
        HttpMethod httpMethod;
        UMOMessage msg = event.getMessage();
        String method = msg.getStringProperty("http.method", "POST");
        URI uri = event.getEndpoint().getEndpointURI().getUri();
        Object body = event.getTransformedMessage();
        if (body instanceof HttpMethod) {
            httpMethod = (HttpMethod)body;
        } else if ("GET".equalsIgnoreCase(method)) {
            httpMethod = new GetMethod(uri.toString());
        } else if ("PUT".equalsIgnoreCase(method)) {
            postMethod = new PutMethod(uri.toString());
            httpMethod = this.createEntityMethod(event, body, (EntityEnclosingMethod)postMethod);
        } else if ("POST".equalsIgnoreCase(method)) {
            postMethod = new PostMethod(uri.toString());
            httpMethod = this.createEntityMethod(event, body, (EntityEnclosingMethod)postMethod);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            httpMethod = new DeleteMethod(uri.toString());
        } else if ("HEAD".equalsIgnoreCase(method)) {
            httpMethod = new HeadMethod(uri.toString());
        } else if ("OPTIONS".equalsIgnoreCase(method)) {
            httpMethod = new OptionsMethod(uri.toString());
        } else if ("TRACE".equalsIgnoreCase(method)) {
            httpMethod = new TraceMethod(uri.toString());
        } else {
            throw new TransformerException(HttpMessages.unsupportedMethod(method));
        }
        var5_6.setDoAuthentication(true);
        if (event.getCredentials() != null) {
            String authScopeHost = msg.getStringProperty("http.auth.scope.host", null);
            int authScopePort = msg.getIntProperty("http.auth.scope.port", -1);
            String authScopeRealm = msg.getStringProperty("http.auth.scope.realm", null);
            String authScopeScheme = msg.getStringProperty("http.auth.scope.scheme", null);
            this.client.getState().setCredentials(new AuthScope(authScopeHost, authScopePort, authScopeRealm, authScopeScheme), (Credentials)new UsernamePasswordCredentials(event.getCredentials().getUsername(), new String(event.getCredentials().getPassword())));
            this.client.getParams().setAuthenticationPreemptive(true);
        } else {
            this.client.getParams().setAuthenticationPreemptive(false);
        }
        return var5_6;
    }

    protected HttpMethod createEntityMethod(UMOEvent event, Object body, EntityEnclosingMethod postMethod) throws TransformerException {
        HttpMethod httpMethod;
        if (body instanceof String) {
            ObjectToHttpClientMethodRequest trans = new ObjectToHttpClientMethodRequest();
            httpMethod = (HttpMethod)trans.transform(body.toString());
        } else if (body instanceof UMOStreamMessageAdapter) {
            UMOStreamMessageAdapter sma = (UMOStreamMessageAdapter)body;
            Map headers = sma.getOutputHandler().getHeaders(event);
            Iterator iterator = headers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                postMethod.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
            postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity((UMOStreamMessageAdapter)((StreamMessageAdapter)body), event));
            postMethod.setContentChunked(true);
            httpMethod = postMethod;
        } else {
            byte[] buffer = event.getTransformedMessageAsBytes();
            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, event.getEncoding()));
            httpMethod = postMethod;
        }
        return httpMethod;
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        MuleMessage muleMessage;
        HttpMethod httpMethod = this.getMethod(event);
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new MuleHttpMethodRetryHandler());
        httpMethod = this.execute(event, httpMethod, false);
        try {
            MuleMessage m;
            Header header;
            Properties h = new Properties();
            Header[] headers = httpMethod.getResponseHeaders();
            for (int i = 0; i < headers.length; ++i) {
                h.setProperty(headers[i].getName(), headers[i].getValue());
            }
            String status = String.valueOf(httpMethod.getStatusCode());
            h.setProperty("http.status", status);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Http response is: " + status));
            }
            ExceptionPayload ep = null;
            if (httpMethod.getStatusCode() >= 400) {
                ep = new ExceptionPayload((Throwable)new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new Exception("Http call returned a status of: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText())));
            }
            if ((header = httpMethod.getResponseHeader("Content-Type")) != null && event.isStreaming()) {
                HttpStreamMessageAdapter sp = (HttpStreamMessageAdapter)this.connector.getStreamMessageAdapter(httpMethod.getResponseBodyAsStream(), null);
                sp.setHttpMethod(httpMethod);
                m = new MuleMessage((Object)sp, (Map)h);
            } else {
                Object body = IOUtils.toByteArray((InputStream)httpMethod.getResponseBodyAsStream());
                if (body == null) {
                    body = "";
                }
                UMOMessageAdapter adapter = this.connector.getMessageAdapter(new Object[]{body, h});
                m = new MuleMessage((Object)adapter);
            }
            m.setExceptionPayload((UMOExceptionPayload)ep);
            muleMessage = m;
            Object var12_13 = null;
        }
        catch (Exception e) {
            try {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            catch (Throwable throwable) {
                block11: {
                    Object var12_14 = null;
                    if (httpMethod == null || event.isStreaming()) break block11;
                    httpMethod.releaseConnection();
                }
                throw throwable;
            }
        }
        if (httpMethod != null && !event.isStreaming()) {
            httpMethod.releaseConnection();
        }
        return muleMessage;
    }

    protected HostConfiguration getHostConfig(URI uri) throws URISyntaxException {
        Protocol protocol = Protocol.getProtocol((String)uri.getScheme().toLowerCase());
        String host = uri.getHost();
        int port = uri.getPort();
        HostConfiguration config = new HostConfiguration();
        config.setHost(host, port, protocol);
        if (StringUtils.isNotBlank((String)this.connector.getProxyHostname())) {
            config.setProxy(this.connector.getProxyHostname(), this.connector.getProxyPort());
        }
        return config;
    }

    protected void doDispose() {
    }

    protected class StreamPayloadRequestEntity
    implements RequestEntity {
        private UMOStreamMessageAdapter messageAdapter;
        private UMOEvent event;

        public StreamPayloadRequestEntity(UMOStreamMessageAdapter messageAdapter, UMOEvent event) {
            this.messageAdapter = messageAdapter;
            this.event = event;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream outputStream) throws IOException {
            this.messageAdapter.getOutputHandler().write(this.event, outputStream);
        }

        public long getContentLength() {
            return -1L;
        }

        public String getContentType() {
            return this.event.getMessage().getStringProperty("Content-Type", null);
        }
    }
}

