/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.components;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.providers.NullPayload;
import org.mule.providers.http.components.RestServiceException;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.properties.MessagePropertyExtractor;
import org.mule.util.properties.PropertyExtractor;

public class RestServiceWrapper
implements Callable,
Initialisable {
    public static final String REST_SERVICE_URL = "rest.service.url";
    public static final String GET = "GET";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_VALUE = "application/x-www-form-urlencoded";
    public static final String HTTP_METHOD = "http.method";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String serviceUrl;
    private boolean urlFromMessage = false;
    private Map requiredParams = new HashMap();
    private Map optionalParams = new HashMap();
    private String httpMethod = "GET";
    private List payloadParameterNames;
    private UMOFilter errorFilter;
    private String errorExpression;
    private PropertyExtractor propertyExtractor = new MessagePropertyExtractor();

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean isUrlFromMessage() {
        return this.urlFromMessage;
    }

    public void setUrlFromMessage(boolean urlFromMessage) {
        this.urlFromMessage = urlFromMessage;
    }

    public Map getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(Map requiredParams) {
        this.requiredParams = requiredParams;
    }

    public Map getOptionalParams() {
        return this.optionalParams;
    }

    public void setOptionalParams(Map optionalParams) {
        this.optionalParams = optionalParams;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public List getPayloadParameterNames() {
        return this.payloadParameterNames;
    }

    public void setPayloadParameterNames(List payloadParameterNames) {
        this.payloadParameterNames = payloadParameterNames;
    }

    public UMOFilter getFilter() {
        return this.errorFilter;
    }

    public void setFilter(UMOFilter errorFilter) {
        this.errorFilter = errorFilter;
    }

    public String getErrorExpression() {
        return this.errorExpression;
    }

    public void setErrorExpression(String errorExpression) {
        this.errorExpression = errorExpression;
    }

    public void initialise() throws InitialisationException {
        if (this.serviceUrl == null && !this.urlFromMessage) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"serviceUrl"), (Initialisable)this);
        }
        if (this.serviceUrl != null) {
            try {
                new URL(this.serviceUrl);
            }
            catch (MalformedURLException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        if (this.errorFilter == null) {
            if (this.errorExpression == null) {
                this.errorFilter = new MessagePropertyFilter("http.status!=200");
                this.logger.info((Object)"Setting default error filter to MessagePropertyFilter('http.status!=200')");
            } else {
                this.errorFilter = new RegExFilter(this.errorExpression);
            }
        }
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        Object requestBody;
        String tempUrl;
        Object request = eventContext.getTransformedMessage();
        if (this.urlFromMessage) {
            tempUrl = eventContext.getMessage().getStringProperty(REST_SERVICE_URL, null);
            if (tempUrl == null) {
                throw new IllegalArgumentException(CoreMessages.propertyIsNotSetOnEvent((String)REST_SERVICE_URL).toString());
            }
        } else {
            tempUrl = this.serviceUrl;
        }
        StringBuffer urlBuffer = new StringBuffer(tempUrl);
        if (GET.equalsIgnoreCase(this.httpMethod)) {
            requestBody = NullPayload.getInstance();
            this.setRESTParams(urlBuffer, eventContext.getMessage(), request, this.requiredParams, false, null);
            this.setRESTParams(urlBuffer, eventContext.getMessage(), request, this.optionalParams, true, null);
        } else {
            StringBuffer requestBodyBuffer = new StringBuffer();
            eventContext.getMessage().setProperty(CONTENT_TYPE, (Object)CONTENT_TYPE_VALUE);
            this.setRESTParams(urlBuffer, eventContext.getMessage(), request, this.requiredParams, false, requestBodyBuffer);
            this.setRESTParams(urlBuffer, eventContext.getMessage(), request, this.optionalParams, true, requestBodyBuffer);
            requestBody = requestBodyBuffer.toString();
        }
        tempUrl = urlBuffer.toString();
        this.logger.info((Object)("Invoking REST service: " + tempUrl));
        eventContext.getMessage().setProperty(HTTP_METHOD, (Object)this.httpMethod);
        UMOMessage result = eventContext.sendEvent((UMOMessage)new MuleMessage(requestBody, (UMOMessageAdapter)eventContext.getMessage()), tempUrl);
        if (this.isErrorPayload(result)) {
            this.handleException(new RestServiceException(CoreMessages.failedToInvokeRestService((String)tempUrl), result), result);
        }
        return result;
    }

    private String getSeparator(String url) {
        String sep = url.indexOf("?") > -1 ? "&" : "?";
        return sep;
    }

    private String updateSeparator(String sep) {
        if (sep.compareTo("?") == 0 || sep.compareTo("") == 0) {
            return "&";
        }
        return sep;
    }

    private void setRESTParams(StringBuffer url, UMOMessage msg, Object body, Map args, boolean optional, StringBuffer requestBodyBuffer) {
        String sep = requestBodyBuffer == null ? this.getSeparator(url.toString()) : "";
        Iterator iterator = args.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String exp = (String)entry.getValue();
            Object value = this.propertyExtractor.getProperty(exp, (Object)msg);
            if (value == null) {
                if (!optional) {
                    throw new IllegalArgumentException(CoreMessages.propertyIsNotSetOnEvent((String)exp).toString());
                }
            } else if (requestBodyBuffer != null) {
                requestBodyBuffer.append(sep);
                requestBodyBuffer.append(name).append('=').append(value);
            } else {
                url.append(sep);
                url.append(name).append('=').append(value);
            }
            sep = this.updateSeparator(sep);
        }
        if (!optional && this.payloadParameterNames != null) {
            if (body instanceof Object[]) {
                Object[] requestArray = (Object[])body;
                for (int i = 0; i < this.payloadParameterNames.size(); ++i) {
                    if (requestBodyBuffer != null) {
                        requestBodyBuffer.append(sep).append(this.payloadParameterNames.get(i)).append('=').append(requestArray[i].toString());
                    } else {
                        url.append(sep).append(this.payloadParameterNames.get(i)).append('=').append(requestArray[i].toString());
                    }
                    sep = this.updateSeparator(sep);
                }
            } else if (this.payloadParameterNames.get(0) != null) {
                if (requestBodyBuffer != null) {
                    requestBodyBuffer.append(this.payloadParameterNames.get(0)).append('=').append(body.toString());
                } else {
                    url.append(sep).append(this.payloadParameterNames.get(0)).append('=').append(body.toString());
                }
            }
        }
    }

    protected boolean isErrorPayload(UMOMessage message) {
        return this.errorFilter != null && this.errorFilter.accept(message);
    }

    protected void handleException(RestServiceException e, UMOMessage result) throws Exception {
        throw e;
    }
}

