/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.mule.impl.MuleMessage;
import org.mule.impl.message.ExceptionPayload;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.http.CookieHelper;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.HttpMessageAdapter;
import org.mule.providers.http.MuleHttpMethodRetryHandler;
import org.mule.providers.http.ReleasingInputStream;
import org.mule.providers.http.StreamPayloadRequestEntity;
import org.mule.providers.http.transformers.HttpClientMethodResponseToObject;
import org.mule.providers.http.transformers.ObjectToHttpClientMethodRequest;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.OutputHandler;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.StringUtils;

public class HttpClientMessageDispatcher
extends AbstractMessageDispatcher {
    public static final int ERROR_STATUS_CODE_RANGE_START = 400;
    private final HttpConnector connector;
    private volatile HttpClient client = null;
    private final UMOTransformer receiveTransformer;
    private final UMOTransformer sendTransformer;

    public HttpClientMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (HttpConnector)endpoint.getConnector();
        this.receiveTransformer = new HttpClientMethodResponseToObject();
        this.sendTransformer = new ObjectToHttpClientMethodRequest();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect();
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(UMOEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        try {
            this.execute(event, httpMethod);
            if (httpMethod.getStatusCode() >= 400) {
                this.logger.error((Object)httpMethod.getResponseBodyAsString());
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new Exception("Http call returned a status of: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText()));
            }
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    protected HttpMethod execute(UMOEvent event, HttpMethod httpMethod) throws Exception {
        try {
            URI uri = event.getEndpoint().getEndpointURI().getUri();
            this.processCookies(event);
            this.client.executeMethod(this.getHostConfig(uri), httpMethod);
            return httpMethod;
        }
        catch (IOException e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected void processCookies(UMOEvent event) {
        UMOMessage msg = event.getMessage();
        Cookie[] cookies = (Cookie[])msg.removeProperty("cookies");
        if (cookies != null && cookies.length > 0) {
            String policy = (String)msg.removeProperty("cookieSpec");
            this.client.getParams().setCookiePolicy(CookieHelper.getCookiePolicy(policy));
            this.client.getState().addCookies(cookies);
        }
    }

    protected HttpMethod getMethod(UMOEvent event) throws TransformerException {
        UMOMessage msg = event.getMessage();
        this.setPropertyFromEndpoint(event, msg, "http.custom.headers");
        Object body = event.getTransformedMessage();
        HttpMethod httpMethod = body instanceof HttpMethod ? (HttpMethod)body : (HttpMethod)this.sendTransformer.transform((Object)msg);
        return httpMethod;
    }

    protected void setPropertyFromEndpoint(UMOEvent event, UMOMessage msg, String prop) {
        Object o = msg.getProperty(prop, null);
        if (o == null && (o = event.getEndpoint().getProperty((Object)prop)) != null) {
            msg.setProperty(prop, o);
        }
    }

    protected HttpMethod createEntityMethod(UMOEvent event, Object body, EntityEnclosingMethod postMethod) throws TransformerException {
        HttpMethod httpMethod;
        if (body instanceof String) {
            ObjectToHttpClientMethodRequest trans = new ObjectToHttpClientMethodRequest();
            httpMethod = (HttpMethod)trans.transform(body.toString());
        } else if (body instanceof byte[]) {
            byte[] buffer = event.getTransformedMessageAsBytes();
            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, event.getEncoding()));
            httpMethod = postMethod;
        } else {
            if (!(body instanceof OutputHandler)) {
                body = event.getTransformedMessage(OutputHandler.class);
            }
            OutputHandler outputHandler = (OutputHandler)body;
            postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity(outputHandler, event));
            postMethod.setContentChunked(true);
            httpMethod = postMethod;
        }
        return httpMethod;
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        HttpMethod httpMethod = this.getMethod(event);
        this.connector.setupClientAuthorization(event, httpMethod, this.client, this.endpoint);
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new MuleHttpMethodRetryHandler());
        Object body = null;
        boolean releaseConn = false;
        try {
            Object is;
            httpMethod = this.execute(event, httpMethod);
            ExceptionPayload ep = null;
            if (httpMethod.getStatusCode() >= 400) {
                ep = new ExceptionPayload((Throwable)new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)new Exception("Http call returned a status of: " + httpMethod.getStatusCode() + " " + httpMethod.getStatusText())));
            }
            if ((is = httpMethod.getResponseBodyAsStream()) == null) {
                body = "";
                releaseConn = true;
            } else {
                is = new ReleasingInputStream((InputStream)is, httpMethod);
                body = is;
            }
            Header[] headers = httpMethod.getResponseHeaders();
            HttpMessageAdapter adapter = new HttpMessageAdapter(new Object[]{body, headers});
            String status = String.valueOf(httpMethod.getStatusCode());
            adapter.setProperty("http.status", status);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Http response is: " + status));
            }
            MuleMessage m = new MuleMessage((Object)adapter);
            m.setExceptionPayload((UMOExceptionPayload)ep);
            MuleMessage muleMessage = m;
            return muleMessage;
        }
        catch (Exception e) {
            releaseConn = true;
            if (e instanceof DispatchException) {
                throw (DispatchException)e;
            }
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        finally {
            if (releaseConn) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected HostConfiguration getHostConfig(URI uri) throws URISyntaxException {
        Protocol protocol = Protocol.getProtocol((String)uri.getScheme().toLowerCase());
        String host = uri.getHost();
        int port = uri.getPort();
        HostConfiguration config = new HostConfiguration();
        config.setHost(host, port, protocol);
        if (StringUtils.isNotBlank((String)this.connector.getProxyHostname())) {
            config.setProxy(this.connector.getProxyHostname(), this.connector.getProxyPort());
        }
        return config;
    }

    protected void doDispose() {
    }
}

