/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.providers.AbstractMessageRequester;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.i18n.HttpMessages;
import org.mule.providers.http.transformers.HttpClientMethodResponseToObject;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.transformer.UMOTransformer;

public class HttpClientMessageRequester
extends AbstractMessageRequester {
    private final HttpConnector connector;
    private volatile HttpClient client = null;
    private final UMOTransformer receiveTransformer;

    public HttpClientMessageRequester(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (HttpConnector)endpoint.getConnector();
        this.receiveTransformer = new HttpClientMethodResponseToObject();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect();
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected UMOMessage doRequest(long timeout) throws Exception {
        GetMethod httpMethod = new GetMethod(this.endpoint.getEndpointURI().getAddress());
        this.connector.setupClientAuthorization(null, (HttpMethod)httpMethod, this.client, this.endpoint);
        boolean releaseConn = false;
        try {
            HttpClient client = new HttpClient();
            client.executeMethod((HttpMethod)httpMethod);
            if (httpMethod.getStatusCode() == 200) {
                UMOMessage res = (UMOMessage)this.receiveTransformer.transform((Object)httpMethod);
                if ("".equals(res.getPayload())) {
                    releaseConn = true;
                }
                UMOMessage uMOMessage = res;
                return uMOMessage;
            }
            try {
                releaseConn = true;
                throw new ReceiveException(HttpMessages.requestFailedWithStatus(httpMethod.getStatusLine().toString()), this.endpoint, timeout);
            }
            catch (ReceiveException e) {
                releaseConn = true;
                throw e;
            }
            catch (Exception e) {
                releaseConn = true;
                throw new ReceiveException(this.endpoint, timeout, (Throwable)e);
            }
        }
        finally {
            if (releaseConn) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected void doDispose() {
    }
}

