/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.http.HttpResponse;
import org.mule.umo.provider.UMOMessageAdapter;

public class HttpMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -1544495479333000422L;
    private boolean http11 = true;
    private Object message;

    public HttpMessageAdapter(Object message) {
        NameValuePair param;
        HeaderElement[] values;
        Header contenttype;
        if (message instanceof Object[]) {
            HashMap headers = new HashMap();
            this.message = ((Object[])message)[0];
            if (((Object[])message).length > 1) {
                Object second = ((Object[])message)[1];
                if (second instanceof Map) {
                    Map props = (Map)second;
                    Iterator iterator = props.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry e = iterator.next();
                        String key = (String)e.getKey();
                        Object value = e.getValue();
                        if (value == null) continue;
                        headers.put(key, value);
                    }
                } else if (second instanceof Header[]) {
                    Header[] inboundHeaders = (Header[])second;
                    for (int i = 0; i < inboundHeaders.length; ++i) {
                        headers.put(inboundHeaders[i].getName(), inboundHeaders[i].getValue());
                    }
                }
                this.addInboundProperties(headers);
            }
        } else {
            if (message instanceof HttpResponse) {
                this.message = message;
                return;
            }
            this.message = message;
        }
        String temp = this.getStringProperty("http.version", null);
        if ("HTTP/1.0".equalsIgnoreCase(temp)) {
            this.http11 = false;
        }
        if ((contenttype = this.getHeader("Content-Type")) != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            this.encoding = param.getValue();
        }
    }

    protected HttpMessageAdapter(HttpMessageAdapter template) {
        super((UMOMessageAdapter)template);
        this.message = template.message;
        this.http11 = template.http11;
    }

    public Object getPayload() {
        return this.message;
    }

    public Object getProperty(String key) {
        if ("Keep-Alive".equals(key) || "Connection".equals(key)) {
            if (!this.http11) {
                String connection = super.getStringProperty("Connection", null);
                if (connection != null && connection.equalsIgnoreCase("close")) {
                    return "false";
                }
                return "true";
            }
            return super.getProperty("Connection") != null ? "true" : "false";
        }
        return super.getProperty(key);
    }

    public Header getHeader(String name) {
        String value = this.getStringProperty(name, null);
        if (value == null) {
            return null;
        }
        return new Header(name, value);
    }

    public ThreadSafeAccess newThreadCopy() {
        return new HttpMessageAdapter(this);
    }
}

