/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.Collections;
import java.util.Map;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.providers.AbstractPollingMessageReceiver;
import org.mule.providers.DefaultMessageAdapter;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.MapUtils;

public class PollingHttpMessageReceiver
extends AbstractPollingMessageReceiver {
    protected String etag = null;
    private boolean checkEtag;

    public PollingHttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws CreateException {
        super(connector, component, (UMOImmutableEndpoint)endpoint);
        long pollingFrequency = MapUtils.getLongValue((Map)endpoint.getProperties(), (Object)"pollingFrequency", (long)-1L);
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
        this.checkEtag = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"checkEtag", (boolean)true);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() throws Exception {
        MuleMessage req = new MuleMessage((Object)new DefaultMessageAdapter((Object)""));
        if (this.etag != null && this.checkEtag) {
            Map<String, String> customHeaders = Collections.singletonMap("If-None-Match", this.etag);
            req.setProperty("http.custom.headers", customHeaders);
        }
        req.setProperty("http.method", (Object)"GET");
        MuleSession session = new MuleSession(this.component);
        MuleEvent event = new MuleEvent((UMOMessage)req, this.endpoint, (UMOSession)session, true);
        UMOMessage message = this.connector.send(this.endpoint, (UMOEvent)event);
        int status = message.getIntProperty("http.status", 0);
        this.etag = message.getStringProperty("ETag", null);
        if (status != 304 || !this.checkEtag) {
            this.routeMessage(message, this.endpoint.isSynchronous());
        }
    }
}

