/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.ResponseWriter;

public class HttpServerConnection {
    private static final Log logger = LogFactory.getLog(HttpServerConnection.class);
    private Socket socket;
    private final InputStream in;
    private final OutputStream out;
    private boolean keepAlive = false;
    private final String encoding;

    public HttpServerConnection(Socket socket, String encoding) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.in = socket.getInputStream();
        this.out = new DataOutputStream(socket.getOutputStream());
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block9: {
            try {
                if (this.socket == null) break block9;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closing: " + this.socket));
                }
                try {
                    this.socket.shutdownOutput();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                this.socket.close();
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("(Ignored) Error closing the socket: " + e.getMessage()));
                }
            }
            finally {
                this.socket = null;
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.socket != null;
    }

    public void setKeepAlive(boolean b) {
        this.keepAlive = b;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public ResponseWriter getWriter() throws UnsupportedEncodingException {
        return new ResponseWriter(this.out);
    }

    public HttpRequest readRequest() throws IOException {
        try {
            String line = this.readLine();
            if (line == null) {
                return null;
            }
            return new HttpRequest(RequestLine.parseLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)this.encoding), this.in);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public HttpResponse readResponse() throws IOException {
        try {
            String line = this.readLine();
            return new HttpResponse(new StatusLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)this.encoding), this.in);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private String readLine() throws IOException {
        String line;
        while ((line = HttpParser.readLine((InputStream)this.in, (String)this.encoding)) != null && line.length() == 0) {
        }
        if (line == null) {
            this.setKeepAlive(false);
            return null;
        }
        return line;
    }

    public void writeRequest(HttpRequest request) throws IOException {
        if (request == null) {
            return;
        }
        ResponseWriter writer = new ResponseWriter(this.out, this.encoding);
        writer.println(request.getRequestLine().toString());
        Iterator item = request.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        OutputStream outstream = this.out;
        InputStream content = request.getBody();
        if (content != null) {
            Header transferenc = request.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                request.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream(outstream);
                }
            }
            IOUtils.copy((InputStream)content, (OutputStream)outstream);
            if (outstream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outstream).finish();
            }
        }
        outstream.flush();
    }

    public void writeResponse(HttpResponse response) throws IOException {
        if (response == null) {
            return;
        }
        this.setKeepAlive(response.isKeepAlive());
        ResponseWriter writer = new ResponseWriter(this.out, this.encoding);
        OutputStream outstream = this.out;
        writer.println(response.getStatusLine());
        Iterator item = response.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        InputStream content = response.getBody();
        if (content != null) {
            Header transferenc = response.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                response.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream(outstream);
                }
            }
            IOUtils.copy((InputStream)content, (OutputStream)outstream);
            if (outstream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outstream).finish();
            }
            content.close();
        }
        outstream.flush();
    }

    public int getSocketTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void setSocketTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }
}

