/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.http.HttpMessageReceiver;

public class HttpsMessageReceiver
extends HttpMessageReceiver {
    public HttpsMessageReceiver(Connector connector, Service service, Endpoint endpoint) throws CreateException {
        super(connector, service, (ImmutableEndpoint)endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpsWorker(socket);
    }

    private class HttpsWorker
    extends HttpMessageReceiver.HttpWorker
    implements HandshakeCompletedListener {
        private Certificate[] peerCertificateChain;
        private Certificate[] localCertificateChain;

        public HttpsWorker(Socket socket) throws IOException {
            super(socket);
            ((SSLSocket)socket).addHandshakeCompletedListener(this);
        }

        protected void preRouteMessage(MuleMessage message) {
            super.preRouteMessage(message);
            if (this.peerCertificateChain != null) {
                message.setProperty("PEER_CERTIFICATES", (Object)this.peerCertificateChain);
            }
            if (this.localCertificateChain != null) {
                message.setProperty("LOCAL_CERTIFICATES", (Object)this.localCertificateChain);
            }
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.localCertificateChain = event.getLocalCertificates();
            try {
                this.peerCertificateChain = event.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                HttpsMessageReceiver.this.logger.debug((Object)("Cannot get peer certificate chain: " + e.getMessage()));
            }
        }
    }
}

