/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.jetty;

import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.http.jetty.JettyReceiverServlet;
import org.mule.transport.http.servlet.MuleRESTReceiverServlet;
import org.mule.transport.http.servlet.ServletConnector;
import org.mule.util.StringUtils;

public class JettyHttpMessageReceiver
extends AbstractMessageReceiver {
    public static final String JETTY_SERVLET_CONNECTOR_NAME = "_jettyConnector";
    private Server httpServer;

    public JettyHttpMessageReceiver(Connector connector, Service service, Endpoint endpoint) throws CreateException {
        super(connector, service, (ImmutableEndpoint)endpoint);
        if ("rest".equals(endpoint.getEndpointURI().getScheme())) {
            ServletConnector scon = (ServletConnector)RegistryContext.getRegistry().lookupConnector(JETTY_SERVLET_CONNECTOR_NAME);
            if (scon != null) {
                throw new CreateException(HttpMessages.noServletConnectorFound(JETTY_SERVLET_CONNECTOR_NAME), (Object)this);
            }
            scon = new ServletConnector();
            scon.setName(JETTY_SERVLET_CONNECTOR_NAME);
            scon.setServletUrl(endpoint.getEndpointURI().getAddress());
            try {
                MuleContext muleContext = MuleServer.getMuleContext();
                scon.setMuleContext(muleContext);
                muleContext.getRegistry().registerConnector((Connector)scon);
                String path = endpoint.getEndpointURI().getPath();
                if (StringUtils.isEmpty((String)path)) {
                    path = "/";
                }
                EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("servlet://" + path.substring(1), connector.getMuleContext());
                endpointBuilder.setTransformers(endpoint.getTransformers());
                ImmutableEndpoint ep = connector.getMuleContext().getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder);
                scon.registerListener(service, ep);
            }
            catch (Exception e) {
                throw new CreateException((Throwable)e, (Object)this);
            }
        }
    }

    protected void doConnect() throws Exception {
        this.httpServer = new Server();
        SocketListener socketListener = new SocketListener(new InetAddrPort(this.endpoint.getEndpointURI().getPort()));
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        socketListener.setMaxIdleTimeMs((int)tp.getThreadTTL());
        int threadsActive = tp.getMaxThreadsActive();
        int threadsMin = socketListener.getMinThreads();
        if (threadsMin >= threadsActive) {
            socketListener.setMinThreads(threadsActive - 1);
        }
        socketListener.setMaxThreads(threadsActive);
        this.httpServer.addListener((HttpListener)socketListener);
        String path = this.endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)path)) {
            path = "/";
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        HttpContext context = this.httpServer.getContext("/");
        context.setRequestLog(null);
        ServletHandler handler = new ServletHandler();
        if ("rest".equals(this.endpoint.getEndpointURI().getScheme())) {
            handler.addServlet("MuleRESTReceiverServlet", path + "*", MuleRESTReceiverServlet.class.getName());
        } else {
            handler.addServlet("JettyReceiverServlet", path + "*", JettyReceiverServlet.class.getName());
        }
        context.addHandler((HttpHandler)handler);
        context.setAttribute("messageReceiver", (Object)this);
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
        try {
            this.httpServer.stop(false);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Error disposing Jetty recevier on: " + this.endpoint.getEndpointURI().toString()), (Throwable)e);
        }
    }

    protected void doStart() throws MuleException {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws MuleException {
        try {
            this.httpServer.stop(true);
        }
        catch (InterruptedException e) {
            throw new LifecycleException(CoreMessages.failedToStop((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }
}

