/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.servlet;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mule.api.MessagingException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.UniqueIdNotSupportedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageAdapter;

public class HttpRequestMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -4238448252206941125L;
    private HttpServletRequest request;

    public HttpRequestMessageAdapter(Object message) throws MessagingException {
        if (message instanceof HttpServletRequest) {
            String key;
            this.setPayload((HttpServletRequest)message);
            Map parameterMap = this.request.getParameterMap();
            if (parameterMap != null && parameterMap.size() > 0) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    String key2 = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    if (value.getClass().isArray() && ((Object[])value).length == 1) {
                        this.setProperty(key2, ((Object[])value)[0]);
                        continue;
                    }
                    this.setProperty(key2, value);
                }
            }
            Enumeration e = this.request.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                this.properties.setProperty(key, this.request.getAttribute(key));
            }
            Enumeration e2 = this.request.getHeaderNames();
            while (e2.hasMoreElements()) {
                String realKey = key = (String)e2.nextElement();
                if (key.startsWith("X-MULE_")) {
                    realKey = key.substring(2);
                }
                this.setProperty(realKey, this.request.getHeader(key));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    protected HttpRequestMessageAdapter(HttpRequestMessageAdapter template) {
        super((MessageAdapter)template);
        this.request = template.request;
    }

    public Object getPayload() {
        return this.request;
    }

    public boolean isBinary() {
        return !this.request.getContentType().startsWith("text");
    }

    private void setPayload(HttpServletRequest message) throws MessagingException {
        this.request = message;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getUniqueId() {
        HttpSession session = null;
        try {
            session = this.getRequest().getSession();
        }
        catch (Exception e) {
            throw new UniqueIdNotSupportedException((MessageAdapter)this, CoreMessages.objectIsNull((String)"Http session"));
        }
        if (session == null) {
            throw new UniqueIdNotSupportedException((MessageAdapter)this, CoreMessages.objectIsNull((String)"Http session"));
        }
        return session.getId();
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo.toString().startsWith("http")) {
            this.setProperty("Location", replyTo);
        }
        this.setProperty("MULE_CORRELATION_ID", replyTo);
    }

    public Object getReplyTo() {
        String replyto = (String)this.getProperty("MULE_REPLYTO");
        if (replyto == null) {
            replyto = (String)this.getProperty("Location");
        }
        return replyto;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new HttpRequestMessageAdapter(this);
    }
}

