/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractDiscoverableTransformer;
import org.mule.util.SystemUtils;

public class HttpRequestToParameter
extends AbstractDiscoverableTransformer {
    public HttpRequestToParameter() {
        this.registerSourceType(HttpServletRequest.class);
        this.setReturnClass(String.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        String payload;
        HttpServletRequest request = (HttpServletRequest)src;
        String payloadParam = (String)request.getAttribute("org.mule.servlet.payload.param");
        if (null == payloadParam) {
            payloadParam = "payload";
        }
        if (null == (payload = request.getParameter(payloadParam)) && this.isText(request.getContentType())) {
            try {
                BufferedReader reader = request.getReader();
                StringBuffer buffer = new StringBuffer(8192);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    buffer.append(SystemUtils.LINE_SEPARATOR);
                }
                payload = buffer.toString();
            }
            catch (IOException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
        return payload;
    }

    protected boolean isText(String contentType) {
        if (contentType == null) {
            return true;
        }
        return contentType.startsWith("text/");
    }
}

