/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Collections;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.util.MapUtils;

public class PollingHttpMessageReceiver
extends AbstractPollingMessageReceiver {
    protected String etag = null;
    private boolean checkEtag;

    public PollingHttpMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        long pollingFrequency = MapUtils.getLongValue((Map)endpoint.getProperties(), (Object)"pollingFrequency", (long)-1L);
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
        this.checkEtag = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"checkEtag", (boolean)true);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() throws Exception {
        DefaultMuleMessage req = new DefaultMuleMessage((Object)new DefaultMessageAdapter((Object)""));
        if (this.etag != null && this.checkEtag) {
            Map<String, String> customHeaders = Collections.singletonMap("If-None-Match", this.etag);
            req.setProperty("http.custom.headers", customHeaders);
        }
        req.setProperty("http.method", (Object)"GET");
        DefaultMuleSession session = new DefaultMuleSession(this.service, this.connector.getMuleContext());
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)req, (ImmutableEndpoint)this.endpoint, (MuleSession)session, true);
        MuleContext muleContext = this.endpoint.getMuleContext();
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder((ImmutableEndpoint)this.endpoint, muleContext);
        OutboundEndpoint outboundEndpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        MuleMessage message = this.connector.send(outboundEndpoint, (MuleEvent)event);
        int status = message.getIntProperty("http.status", 0);
        this.etag = message.getStringProperty("ETag", null);
        if (status != 304 || !this.checkEtag) {
            this.routeMessage(message, this.endpoint.isSynchronous());
        }
    }
}

