/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.util.concurrent.Latch;

public class HttpPollingWithTransformersFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "mule-http-polling-with-transformers-config.xml";
    }

    public void testPollingHttpConnector() throws Exception {
        final Latch latch = new Latch();
        final AtomicBoolean transformPropagated = new AtomicBoolean(false);
        muleContext.registerListener((ServerNotificationListener)new FunctionalTestNotificationListener(){

            public void onNotification(ServerNotification notification) {
                latch.countDown();
                if (notification.getSource().toString().endsWith("toClient-only")) {
                    transformPropagated.set(true);
                }
            }
        }, "polledUMO");
        MuleClient client = new MuleClient();
        MuleMessage result = client.request("vm://toclient", 50000L);
        HttpPollingWithTransformersFunctionalTestCase.assertNotNull((Object)result.getPayload());
        HttpPollingWithTransformersFunctionalTestCase.assertTrue((String)"Callback called", (boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        HttpPollingWithTransformersFunctionalTestCase.assertEquals((String)"/foo toClient-only", (String)result.getPayloadAsString());
        HttpPollingWithTransformersFunctionalTestCase.assertFalse((boolean)transformPropagated.get());
    }
}

