/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.ArrayList;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class TwoEndpointsSinglePortTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "two-endpoints-single-port.xml";
    }

    public void testSendToEach() throws Exception {
        this.sendWithResponse("http://localhost:60211/mycomponent1", "test", "mycomponent1", 10);
        this.sendWithResponse("http://localhost:60211/mycomponent2", "test", "mycomponent2", 10);
    }

    public void testSendToEachWithBadEndpoint() throws Exception {
        MuleClient client = new MuleClient();
        this.sendWithResponse("http://localhost:60211/mycomponent1", "test", "mycomponent1", 5);
        this.sendWithResponse("http://localhost:60211/mycomponent2", "test", "mycomponent2", 5);
        MuleMessage result = client.send("http://localhost:60211/mycomponent-notfound", (Object)"test", null);
        TwoEndpointsSinglePortTestCase.assertNotNull((Object)result);
        TwoEndpointsSinglePortTestCase.assertNotNull((Object)result.getExceptionPayload());
        TwoEndpointsSinglePortTestCase.assertEquals((int)404, (int)result.getIntProperty("http.status", 0));
        this.sendWithResponse("http://localhost:60211/mycomponent1", "test", "mycomponent1", 5);
        this.sendWithResponse("http://localhost:60211/mycomponent2", "test", "mycomponent2", 5);
    }

    protected void sendWithResponse(String endpoint, String message, String response, int noOfMessages) throws MuleException {
        int i;
        MuleClient client = new MuleClient();
        ArrayList<Object> results = new ArrayList<Object>();
        for (i = 0; i < noOfMessages; ++i) {
            results.add(client.send(endpoint, (Object)message, null).getPayload(byte[].class));
        }
        TwoEndpointsSinglePortTestCase.assertEquals((int)noOfMessages, (int)results.size());
        for (i = 0; i < noOfMessages; ++i) {
            TwoEndpointsSinglePortTestCase.assertEquals((String)response, (String)new String((byte[])results.get(i)));
        }
    }
}

