/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.text.MessageFormat;
import org.mule.api.component.Component;
import org.mule.routing.filters.WildcardFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.http.components.RestServiceWrapper;

public class RestServiceComponentTestCase
extends FunctionalTestCase {
    public static final String SERVICE_NAME = "WORMS";
    public static final String SERVICE_URL = MessageFormat.format("{0}header:serviceUrl{1}", "#[", "]");

    protected String getConfigResources() {
        return "rest-service-component-test.xml";
    }

    public void testResetServiceNamespaceHandler() throws Exception {
        Component component = muleContext.getRegistry().lookupService(SERVICE_NAME).getComponent();
        RestServiceComponentTestCase.assertTrue((boolean)(component instanceof RestServiceWrapper));
        RestServiceWrapper restServiceWrapper = (RestServiceWrapper)component;
        RestServiceComponentTestCase.assertEquals((String)restServiceWrapper.getServiceUrl(), (String)SERVICE_URL);
        RestServiceComponentTestCase.assertEquals((String)restServiceWrapper.getHttpMethod(), (String)"POST");
        RestServiceComponentTestCase.assertNotNull((Object)restServiceWrapper.getFilter());
        RestServiceComponentTestCase.assertEquals(NotFilter.class, restServiceWrapper.getFilter().getClass());
        NotFilter filter = (NotFilter)restServiceWrapper.getFilter();
        RestServiceComponentTestCase.assertEquals(filter.getFilter().getClass(), WildcardFilter.class);
        WildcardFilter innerFilter = (WildcardFilter)filter.getFilter();
        RestServiceComponentTestCase.assertEquals((String)innerFilter.getPattern(), (String)"*xyz*");
        RestServiceComponentTestCase.assertNotNull((Object)restServiceWrapper.getPayloadParameterNames());
        RestServiceComponentTestCase.assertEquals((int)restServiceWrapper.getPayloadParameterNames().size(), (int)2);
        RestServiceComponentTestCase.assertEquals(restServiceWrapper.getPayloadParameterNames().get(0), (Object)"test-property1");
        RestServiceComponentTestCase.assertEquals(restServiceWrapper.getPayloadParameterNames().get(1), (Object)"test-property2");
        RestServiceComponentTestCase.assertNotNull((Object)restServiceWrapper.getRequiredParams());
        RestServiceComponentTestCase.assertEquals((int)restServiceWrapper.getRequiredParams().size(), (int)2);
        RestServiceComponentTestCase.assertEquals(restServiceWrapper.getRequiredParams().get("r1"), (Object)"rv1");
        RestServiceComponentTestCase.assertEquals(restServiceWrapper.getRequiredParams().get("r2"), (Object)"rv2");
        RestServiceComponentTestCase.assertNotNull((Object)restServiceWrapper.getOptionalParams());
        RestServiceComponentTestCase.assertEquals((int)restServiceWrapper.getOptionalParams().size(), (int)2);
        RestServiceComponentTestCase.assertEquals(restServiceWrapper.getOptionalParams().get("o1"), (Object)"ov1");
        RestServiceComponentTestCase.assertEquals(restServiceWrapper.getOptionalParams().get("o2"), (Object)"ov2");
    }
}

