/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.filters;

import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class HttpRequestWildcardFilterTestCase
extends FunctionalTestCase {
    private static final String HTTP_ENDPOINT = "http://localhost:60201";
    private static final String REF_ENDPOINT = "http://localhost:60199";
    private static final String TEST_MESSAGE = "Hello=World";
    private static final String TEST_BAD_MESSAGE = "xyz";

    protected String getConfigResources() {
        return "http-wildcard-filter-test.xml";
    }

    public void testReference() throws Exception {
        MuleClient client = new MuleClient();
        MuleMessage result = client.send(REF_ENDPOINT, (Object)TEST_MESSAGE, null);
        HttpRequestWildcardFilterTestCase.assertEquals((String)TEST_MESSAGE, (String)result.getPayloadAsString());
    }

    public void testHttpPost() throws Exception {
        MuleClient client = new MuleClient();
        MuleMessage result = client.send(HTTP_ENDPOINT, (Object)TEST_MESSAGE, null);
        HttpRequestWildcardFilterTestCase.assertEquals((String)TEST_MESSAGE, (String)result.getPayloadAsString());
    }

    public void testHttpGetNotFilter() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("GET", "true");
        MuleClient client = new MuleClient();
        MuleMessage result = client.send(HTTP_ENDPOINT, (Object)TEST_MESSAGE, props);
        HttpRequestWildcardFilterTestCase.assertEquals((String)TEST_MESSAGE, (String)result.getPayloadAsString());
    }

    public void testHttpGetFilter() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("GET", "true");
        MuleClient client = new MuleClient();
        MuleMessage result = client.send(HTTP_ENDPOINT, (Object)TEST_BAD_MESSAGE, props);
        HttpRequestWildcardFilterTestCase.assertEquals((int)406, (int)result.getIntProperty("http.status", 0));
        HttpRequestWildcardFilterTestCase.assertNotNull((Object)result.getExceptionPayload());
    }
}

