/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.InputStream;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.tck.FunctionalTestCase;
import org.mule.util.IOUtils;

public class HttpContentLengthPropagationTestCase
extends FunctionalTestCase {
    private static final String NAME_PAYLOAD = "test-xml-payload.xml";
    private static final String NAME_STYLESHEET = "stylesheet.xsl";

    protected String getConfigResources() {
        return "http-content-length-propagation-conf.xml";
    }

    public void testContentLengthPropagation() throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(NAME_PAYLOAD);
        HttpContentLengthPropagationTestCase.assertNotNull((String)"Payload test file not found.", (Object)is);
        byte[] fileContents = IOUtils.toByteArray((InputStream)is);
        MuleClient client = new MuleClient();
        MuleMessage result = client.send("http://localhost:8085", (MuleMessage)new DefaultMuleMessage((Object)fileContents));
        XsltTransformer trans = new XsltTransformer();
        trans.setXslFile(NAME_STYLESHEET);
        byte[] locallyTransformedBytes = (byte[])trans.doTransform((Object)fileContents, "UTF-8");
        HttpContentLengthPropagationTestCase.assertEquals((String)new String(locallyTransformedBytes), (String)result.getPayloadAsString());
    }
}

