/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class HttpCookieTestCase
extends FunctionalTestCase {
    private static final int LISTEN_PORT = 60212;
    private static final String COOKIE_HEADER = "Cookie:";
    private CountDownLatch simpleServerLatch = new CountDownLatch(1);
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cookieFound = false;

    protected String getConfigResources() {
        return "http-cookie-test.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        new Thread(new SimpleHttpServer()).start();
    }

    public void testCookies() throws Exception {
        HttpCookieTestCase.assertTrue((boolean)this.simpleServerLatch.await(5000L, TimeUnit.MILLISECONDS));
        MuleClient client = new MuleClient();
        client.send("vm://vm-in", (Object)"foobar", null);
        HttpCookieTestCase.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        HttpCookieTestCase.assertTrue((boolean)this.cookieFound);
    }

    private class SimpleHttpServer
    implements Runnable {
        private SimpleHttpServer() {
        }

        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(60212);
                HttpCookieTestCase.this.simpleServerLatch.countDown();
                Socket socket = serverSocket.accept();
                InputStream in = socket.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = reader.readLine();
                while (line != null) {
                    if (line.indexOf(HttpCookieTestCase.COOKIE_HEADER) > -1) {
                        HttpCookieTestCase.this.cookieFound = true;
                        break;
                    }
                    line = reader.readLine();
                    if (line.trim().length() != 0) continue;
                    line = null;
                }
                OutputStream out = socket.getOutputStream();
                out.write("HTTP/1.1 200 OK\n\n".getBytes());
                in.close();
                out.close();
                socket.close();
                serverSocket.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                HttpCookieTestCase.this.latch.countDown();
            }
        }
    }
}

