/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.mule.tck.FunctionalTestCase;

public class HttpMethodTestCase
extends FunctionalTestCase {
    private HttpMethodBase method;

    protected String getConfigResources() {
        return "http-method-test.xml";
    }

    protected void doFunctionalTearDown() throws Exception {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    public void testHead() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HeadMethod("http://localhost:60200");
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testOptions() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new OptionsMethod("http://localhost:60200");
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testPut() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new PutMethod("http://localhost:60200");
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testDelete() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new DeleteMethod("http://localhost:60200");
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testTrace() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new TraceMethod("http://localhost:60200");
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testConnect() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HttpMethodBase("http://localhost:60200"){

            public String getName() {
                return "CONNECT";
            }
        };
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testFoo() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HttpMethodBase("http://localhost:60200"){

            public String getName() {
                return "FOO";
            }
        };
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(400), (String)Integer.toString(statusCode));
    }
}

