/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.SerializationUtils;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.StreamPayloadRequestEntity;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.StringUtils;

public class ObjectToHttpClientMethodRequest
extends AbstractMessageAwareTransformer
implements MuleContextAware {
    private MuleContext muleContext;

    public ObjectToHttpClientMethodRequest() {
        this.setReturnClass(HttpMethod.class);
        this.registerSourceType(MuleMessage.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(OutputHandler.class);
        this.registerSourceType(NullPayload.class);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected int addParameters(String queryString, PostMethod postMethod, MuleMessage msg) {
        String currentParam;
        if (StringUtils.isBlank((String)queryString)) {
            return 0;
        }
        int equals = queryString.indexOf("&");
        if (equals > -1) {
            currentParam = queryString.substring(0, equals);
            queryString = queryString.substring(equals + 1);
        } else {
            currentParam = queryString;
            queryString = "";
        }
        int parameterIndex = -1;
        while (StringUtils.isNotBlank((String)currentParam)) {
            equals = currentParam.indexOf("=");
            if (equals > -1) {
                String paramName = currentParam.substring(0, equals);
                String paramValue = currentParam.substring(equals + 1);
                ++parameterIndex;
                postMethod.addParameter(paramName, paramValue);
            }
            if ((equals = queryString.indexOf("&")) > -1) {
                currentParam = queryString.substring(0, equals);
                queryString = queryString.substring(equals + 1);
                continue;
            }
            currentParam = queryString;
            queryString = "";
        }
        return parameterIndex + 1;
    }

    public Object transform(MuleMessage msg, String outputEncoding) throws TransformerException {
        Object src = msg.getPayload();
        String endpoint = msg.getStringProperty("MULE_ENDPOINT", null);
        if (endpoint == null) {
            throw new TransformerException(HttpMessages.eventPropertyNotSetCannotProcessRequest("MULE_ENDPOINT"), (Transformer)this);
        }
        String method = msg.getStringProperty("http.method", "POST");
        try {
            GetMethod httpMethod;
            endpoint = endpoint.replaceAll("%23", "#");
            endpoint = this.muleContext.getExpressionManager().parse(endpoint, msg, true);
            URI uri = new URI(endpoint);
            if ("GET".equals(method)) {
                httpMethod = new GetMethod(uri.toString());
                String paramName = URLEncoder.encode(msg.getStringProperty("http.get.body.param", "body"), outputEncoding);
                String paramValue = URLEncoder.encode(src.toString(), outputEncoding);
                String query = uri.getRawQuery();
                if (!(src instanceof NullPayload) && !"".equals(src)) {
                    query = query == null ? paramName + "=" + paramValue : query + "&" + paramName + "=" + paramValue;
                }
                httpMethod.setQueryString(query);
            } else if ("POST".equalsIgnoreCase(method)) {
                PostMethod postMethod = new PostMethod(uri.toString());
                String paramName = msg.getStringProperty("http.post.body.param", null);
                if (src instanceof Map) {
                    for (Map.Entry entry : ((Map)src).entrySet()) {
                        postMethod.addParameter(entry.getKey().toString(), entry.getValue().toString());
                    }
                } else if (paramName != null) {
                    postMethod.addParameter(paramName, src.toString());
                } else {
                    this.addParameters(uri.getQuery(), postMethod, msg);
                    this.setupEntityMethod(src, outputEncoding, msg, uri, (EntityEnclosingMethod)postMethod);
                }
                httpMethod = postMethod;
            } else if ("PUT".equalsIgnoreCase(method)) {
                PutMethod putMethod = new PutMethod(uri.toString());
                this.setupEntityMethod(src, outputEncoding, msg, uri, (EntityEnclosingMethod)putMethod);
                httpMethod = putMethod;
            } else if ("DELETE".equalsIgnoreCase(method)) {
                httpMethod = new DeleteMethod(uri.toString());
            } else if ("HEAD".equalsIgnoreCase(method)) {
                httpMethod = new HeadMethod(uri.toString());
            } else if ("OPTIONS".equalsIgnoreCase(method)) {
                httpMethod = new OptionsMethod(uri.toString());
            } else if ("TRACE".equalsIgnoreCase(method)) {
                httpMethod = new TraceMethod(uri.toString());
            } else {
                throw new TransformerException(HttpMessages.unsupportedMethod(method));
            }
            HttpMethodParams params = (HttpMethodParams)msg.removeProperty("http.params");
            if (params != null) {
                httpMethod.setParams(params);
            } else {
                String httpVersion = msg.getStringProperty("http.version", "HTTP/1.1");
                if ("HTTP/1.0".equals(httpVersion)) {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_0);
                } else {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_1);
                }
            }
            this.setHeaders((HttpMethod)httpMethod, msg);
            return httpMethod;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected void setupEntityMethod(Object src, String encoding, MuleMessage msg, URI uri, EntityEnclosingMethod postMethod) throws UnsupportedEncodingException, TransformerException {
        if (!(msg.getPayload() instanceof NullPayload)) {
            String mimeType = (String)msg.getProperty("Content-Type", PropertyScope.OUTBOUND);
            if (src instanceof String) {
                int parameterIndex;
                if (mimeType != null && (parameterIndex = mimeType.indexOf(";")) > 0) {
                    mimeType = mimeType.substring(0, parameterIndex);
                }
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(src.toString(), mimeType, encoding));
                return;
            }
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            if (encoding != null && !"UTF-8".equals(encoding.toUpperCase()) && mimeType.indexOf("charset") == -1) {
                mimeType = mimeType + "; charset=" + encoding;
            }
            if (src instanceof InputStream) {
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)src, mimeType));
            } else if (src instanceof byte[]) {
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity((byte[])src, mimeType));
            } else if (src instanceof OutputHandler) {
                MuleEvent event = RequestContext.getEvent();
                postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity((OutputHandler)src, event));
            } else {
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                byte[] buffer = SerializationUtils.serialize((Serializable)((Serializable)src));
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, mimeType));
            }
        }
    }

    protected void setHeaders(HttpMethod httpMethod, MuleMessage msg) {
        for (String headerName : msg.getPropertyNames()) {
            if (headerName.equalsIgnoreCase("http.custom.headers")) {
                Map customHeaders;
                if (this.logger.isInfoEnabled()) {
                    this.logger.warn((Object)"Deprecation warning:  There is not need to set custom headers using: http.custom.headers you can now add the properties directly to the outbound endpoint or use the OUTBOUND property scope on the message.");
                }
                if ((customHeaders = (Map)msg.getProperty("http.custom.headers")) == null) continue;
                for (Map.Entry entry : customHeaders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    httpMethod.addRequestHeader(entry.getKey().toString(), entry.getValue().toString());
                }
                continue;
            }
            if (HttpConstants.REQUEST_HEADER_NAMES.get(headerName) != null || HttpConnector.HTTP_INBOUND_PROPERTIES.contains(headerName)) continue;
            String headerValue = msg.getStringProperty(headerName, null);
            if (headerName.startsWith("MULE_")) {
                headerName = new StringBuffer(30).append("X-").append(headerName).toString();
            }
            httpMethod.addRequestHeader(headerName, headerValue);
        }
        Set attNams = msg.getAttachmentNames();
        if (msg.getPayload() instanceof InputStream && attNams != null && attNams.size() > 0) {
            httpMethod.addRequestHeader("Content-Type", "multipart/related");
        }
    }

    protected String paramToString(Object param) {
        StringBuffer buf = new StringBuffer();
        if (param instanceof List) {
            List list = (List)param;
            for (Object object : list) {
                buf.append(object).append(",");
            }
            return buf.toString();
        }
        if (param instanceof Map) {
            Map map = (Map)param;
            for (Map.Entry entry : map.entrySet()) {
                buf.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            return buf.toString().substring(0, buf.length() - 1);
        }
        return param.toString();
    }
}

