/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.mule.module.client.MuleClient;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;

public class RestServiceComponentDeleteTestCase
extends AbstractMockHttpServerTestCase {
    private static final int LISTEN_PORT = 60205;
    private CountDownLatch serverRequestCompleteLatch = new CountDownLatch(1);
    private boolean deleteRequestFound = false;

    protected String getConfigResources() {
        return "rest-service-component-delete-test.xml";
    }

    protected MockHttpServer getHttpServer(CountDownLatch serverStartLatch) {
        return new SimpleHttpServer(60205, serverStartLatch, this.serverRequestCompleteLatch);
    }

    public void testRestServiceComponentDelete() throws Exception {
        MuleClient client = new MuleClient();
        client.send("vm://fromTest", (Object)"Test Message", null);
        RestServiceComponentDeleteTestCase.assertTrue((boolean)this.serverRequestCompleteLatch.await(5000L, TimeUnit.MILLISECONDS));
        RestServiceComponentDeleteTestCase.assertTrue((boolean)this.deleteRequestFound);
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String requestLine = reader.readLine();
            String httpMethod = new StringTokenizer(requestLine).nextToken();
            RestServiceComponentDeleteTestCase.this.deleteRequestFound = httpMethod.equals("DELETE");
        }
    }
}

