/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;
import org.mule.transport.http.i18n.HttpMessages;

public class RequestLine {
    private HttpVersion httpversion = null;
    private String method = null;
    private String uri = null;

    public static RequestLine parseLine(String l) throws HttpException {
        String protocol;
        String uri;
        String method;
        try {
            if (l == null) {
                throw new ProtocolException(HttpMessages.requestLineIsMalformed(l).getMessage());
            }
            StringTokenizer st = new StringTokenizer(l, " ");
            method = st.nextToken();
            uri = st.nextToken();
            protocol = st.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new ProtocolException(HttpMessages.requestLineIsMalformed(l).getMessage());
        }
        return new RequestLine(method, uri, protocol);
    }

    public RequestLine(String method, String uri, HttpVersion httpversion) {
        if (method == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null");
        }
        if (httpversion == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        this.method = method;
        this.uri = uri;
        this.httpversion = httpversion;
    }

    public RequestLine(String method, String uri, String httpversion) throws ProtocolException {
        this(method, uri, HttpVersion.parse((String)httpversion));
    }

    public String getMethod() {
        return this.method;
    }

    public HttpVersion getHttpVersion() {
        return this.httpversion;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.method);
        sb.append(" ");
        sb.append(this.uri);
        sb.append(" ");
        sb.append(this.httpversion);
        return sb.toString();
    }
}

