/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.HashMap;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang.time.StopWatch;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class HttpContinueFunctionalTestCase
extends FunctionalTestCase {
    public static final String TEST_MESSAGE = "Foo Bar";
    public static final int DEFAULT_HTTP_CLIENT_CONTINUE_WAIT = 3000;
    protected StopWatch stopWatch;

    protected String getConfigResources() {
        return "http-functional-test.xml";
    }

    public void testSendWithContinue() throws Exception {
        MuleClient client = new MuleClient();
        HashMap<String, HttpClientParams> props = new HashMap<String, HttpClientParams>();
        HttpClientParams params = new HttpClientParams();
        params.setVersion(HttpVersion.HTTP_1_1);
        params.setBooleanParameter("http.protocol.expect-continue", true);
        props.put("http.params", params);
        this.stopWatch = new StopWatch();
        this.stopWatch.start();
        MuleMessage result = client.send("clientEndpoint", (Object)TEST_MESSAGE, props);
        this.stopWatch.stop();
        HttpContinueFunctionalTestCase.assertNotNull((Object)result);
        HttpContinueFunctionalTestCase.assertEquals((String)"Foo Bar Received", (String)result.getPayloadAsString());
        if (this.stopWatch.getTime() > 3000L) {
            HttpContinueFunctionalTestCase.fail((String)"Server did not handle Expect=100-continue header properly,");
        }
    }
}

