/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class HttpHeadersTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "http-headers-config.xml";
    }

    public void testJettyHeaders() throws Exception {
        MuleClient client = new MuleClient();
        MuleMessage result = client.send("clientEndpoint", null, null);
        String contentTypeProperty = result.getAdapter().getStringProperty("Content-Type", null);
        HttpHeadersTestCase.assertNotNull((Object)contentTypeProperty);
        HttpHeadersTestCase.assertEquals((String)"application/x-download", (String)contentTypeProperty);
        String contentDispositionProperty = result.getAdapter().getStringProperty("Content-Disposition", null);
        HttpHeadersTestCase.assertNotNull((Object)contentDispositionProperty);
        HttpHeadersTestCase.assertEquals((String)"attachment; filename=foo.zip", (String)contentDispositionProperty);
    }

    public void testClientHeaders() throws Exception {
        MuleClient client = new MuleClient();
        client.dispatch("clientEndpoint2", null, null);
        MuleMessage result = client.request("vm://out", 5000L);
        String contentTypeProperty = result.getAdapter().getStringProperty("Content-Type", null);
        HttpHeadersTestCase.assertNotNull((Object)contentTypeProperty);
        HttpHeadersTestCase.assertEquals((String)"application/xml", (String)contentTypeProperty);
        String contentDispositionProperty = result.getAdapter().getStringProperty("Content-Disposition", null);
        HttpHeadersTestCase.assertNotNull((Object)contentDispositionProperty);
        HttpHeadersTestCase.assertEquals((String)"attachment; filename=foo.zip", (String)contentDispositionProperty);
        HttpHeadersTestCase.assertNotNull((Object)result.getAdapter().getProperty("X-Test"));
        HttpHeadersTestCase.assertEquals((Object)"foo", (Object)result.getAdapter().getProperty("X-Test"));
    }
}

