/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.mule.api.MuleEventContext;
import org.mule.api.transport.MessageAdapter;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.DefaultMessageAdapter;

public class HttpPersistentQueueTestCase
extends FunctionalTestCase {
    private CountDownLatch messageDidArrive = new CountDownLatch(1);

    protected String getConfigResources() {
        return "http-persistent-queue.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent("PersistentQueueAsync");
        HttpPersistentQueueTestCase.assertNotNull((Object)testComponent);
        testComponent.setEventCallback((EventCallback)new Callback(this.messageDidArrive));
    }

    public void testPersistentMessageDeliveryWithGet() throws Exception {
        GetMethod method = new GetMethod("http://localhost:63083/services/Echo?foo=bar");
        method.addRequestHeader("Connection", "close");
        this.doTestPersistentMessageDelivery((HttpMethod)method);
    }

    public void testPersistentMessageDeliveryWithPost() throws Exception {
        PostMethod method = new PostMethod("http://localhost:63083/services/Echo");
        method.addRequestHeader("Connection", "close");
        method.addParameter(new NameValuePair("foo", "bar"));
        this.doTestPersistentMessageDelivery((HttpMethod)method);
    }

    private void doTestPersistentMessageDelivery(HttpMethod httpMethod) throws Exception {
        HttpClient client = new HttpClient();
        int rc = client.executeMethod(httpMethod);
        HttpPersistentQueueTestCase.assertEquals((int)200, (int)rc);
        HttpPersistentQueueTestCase.assertTrue((boolean)this.messageDidArrive.await(5000L, TimeUnit.MILLISECONDS));
    }

    private static class Callback
    implements EventCallback {
        private CountDownLatch messageDidArrive;

        public Callback(CountDownLatch latch) {
            this.messageDidArrive = latch;
        }

        public void eventReceived(MuleEventContext context, Object component) throws Exception {
            MessageAdapter adapter = context.getMessage().getAdapter();
            Assert.assertTrue((boolean)(adapter instanceof DefaultMessageAdapter));
            Assert.assertEquals((Object)"true", (Object)adapter.getProperty("Connection"));
            Assert.assertEquals((Object)"true", (Object)adapter.getProperty("Keep-Alive"));
            this.messageDidArrive.countDown();
        }
    }
}

