/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class HttpEndpointTestCase
extends AbstractMuleTestCase {
    public void testHostPortOnlyUrl() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://localhost:8080", muleContext);
        endpointUri.initialise();
        HttpEndpointTestCase.assertEquals((String)"http", (String)endpointUri.getScheme());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertNull((Object)endpointUri.getEndpointName());
        HttpEndpointTestCase.assertEquals((int)8080, (int)endpointUri.getPort());
        HttpEndpointTestCase.assertEquals((String)"localhost", (String)endpointUri.getHost());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertEquals((int)0, (int)endpointUri.getParams().size());
    }

    public void testHostPortOnlyUrlAndUserInfo() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://admin:pwd@localhost:8080", muleContext);
        endpointUri.initialise();
        HttpEndpointTestCase.assertEquals((String)"http", (String)endpointUri.getScheme());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertNull((Object)endpointUri.getEndpointName());
        HttpEndpointTestCase.assertEquals((int)8080, (int)endpointUri.getPort());
        HttpEndpointTestCase.assertEquals((String)"localhost", (String)endpointUri.getHost());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertEquals((int)0, (int)endpointUri.getParams().size());
        HttpEndpointTestCase.assertEquals((String)"admin:pwd", (String)endpointUri.getUserInfo());
        HttpEndpointTestCase.assertEquals((String)"admin", (String)endpointUri.getUser());
        HttpEndpointTestCase.assertEquals((String)"pwd", (String)endpointUri.getPassword());
        HttpEndpointTestCase.assertEquals((String)"http://admin:****@localhost:8080", (String)endpointUri.toString());
    }

    public void testHostPortAndPathUrl() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://localhost:8080/app/path", muleContext);
        endpointUri.initialise();
        HttpEndpointTestCase.assertEquals((String)"http", (String)endpointUri.getScheme());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080/app/path", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertNull((Object)endpointUri.getEndpointName());
        HttpEndpointTestCase.assertEquals((int)8080, (int)endpointUri.getPort());
        HttpEndpointTestCase.assertEquals((String)"localhost", (String)endpointUri.getHost());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080/app/path", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertEquals((String)endpointUri.getPath(), (String)"/app/path");
        HttpEndpointTestCase.assertEquals((int)0, (int)endpointUri.getParams().size());
    }

    public void testHostPortAndPathUrlAndUserInfo() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://admin:pwd@localhost:8080/app/path", muleContext);
        endpointUri.initialise();
        HttpEndpointTestCase.assertEquals((String)"http", (String)endpointUri.getScheme());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080/app/path", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertNull((Object)endpointUri.getEndpointName());
        HttpEndpointTestCase.assertEquals((int)8080, (int)endpointUri.getPort());
        HttpEndpointTestCase.assertEquals((String)"localhost", (String)endpointUri.getHost());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080/app/path", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertEquals((String)endpointUri.getPath(), (String)"/app/path");
        HttpEndpointTestCase.assertEquals((int)0, (int)endpointUri.getParams().size());
        HttpEndpointTestCase.assertEquals((String)"admin:pwd", (String)endpointUri.getUserInfo());
        HttpEndpointTestCase.assertEquals((String)"admin", (String)endpointUri.getUser());
        HttpEndpointTestCase.assertEquals((String)"pwd", (String)endpointUri.getPassword());
        HttpEndpointTestCase.assertEquals((String)"http://admin:****@localhost:8080/app/path", (String)endpointUri.toString());
    }

    public void testHostPortAndPathUrlUserInfoAndQuery() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://admin:pwd@localhost:8080/app/path?${foo}", muleContext);
        endpointUri.initialise();
        HttpEndpointTestCase.assertEquals((String)"http", (String)endpointUri.getScheme());
        HttpEndpointTestCase.assertEquals((String)"http://localhost:8080/app/path?$[foo]", (String)endpointUri.getAddress());
        HttpEndpointTestCase.assertNull((Object)endpointUri.getEndpointName());
        HttpEndpointTestCase.assertEquals((int)8080, (int)endpointUri.getPort());
        HttpEndpointTestCase.assertEquals((String)"localhost", (String)endpointUri.getHost());
        HttpEndpointTestCase.assertEquals((String)endpointUri.getPath(), (String)"/app/path");
        HttpEndpointTestCase.assertEquals((String)endpointUri.getQuery(), (String)"$[foo]");
        HttpEndpointTestCase.assertEquals((int)1, (int)endpointUri.getParams().size());
        HttpEndpointTestCase.assertEquals((String)"admin:pwd", (String)endpointUri.getUserInfo());
        HttpEndpointTestCase.assertEquals((String)"admin", (String)endpointUri.getUser());
        HttpEndpointTestCase.assertEquals((String)"pwd", (String)endpointUri.getPassword());
        HttpEndpointTestCase.assertEquals((String)"http://admin:****@localhost:8080/app/path?$[foo]", (String)endpointUri.toString());
    }
}

